/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.constructs.nonstop.NonstopExecutorService;
import net.sf.ehcache.constructs.nonstop.NonstopExecutorServiceFactory;
import net.sf.ehcache.constructs.nonstop.NonstopExecutorServiceImpl;

public final class CacheManagerExecutorServiceFactory
implements NonstopExecutorServiceFactory {
    private static final String EXECUTOR_THREAD_NAME_PREFIX = "Executor Thread";
    private static final CacheManagerExecutorServiceFactory SINGLETON = new CacheManagerExecutorServiceFactory();
    private final Map<String, NonstopExecutorService> executorServiceMap = new HashMap<String, NonstopExecutorService>();

    private CacheManagerExecutorServiceFactory() {
    }

    public static CacheManagerExecutorServiceFactory getInstance() {
        return SINGLETON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonstopExecutorService getOrCreateNonstopExecutorService(CacheManager cacheManager) {
        final String cacheManagerName = cacheManager.getName();
        Map<String, NonstopExecutorService> map = this.executorServiceMap;
        synchronized (map) {
            NonstopExecutorService rv = this.executorServiceMap.get(cacheManagerName);
            if (rv == null) {
                rv = new NonstopExecutorServiceImpl(new ThreadFactory(){
                    private final AtomicInteger count = new AtomicInteger();

                    public Thread newThread(Runnable runnable) {
                        Thread thread = new Thread(runnable, "NonStopCache [" + cacheManagerName + "] " + CacheManagerExecutorServiceFactory.EXECUTOR_THREAD_NAME_PREFIX + "-" + this.count.incrementAndGet() + " for '" + Thread.currentThread().getName() + "'");
                        thread.setDaemon(true);
                        return thread;
                    }
                });
                this.executorServiceMap.put(cacheManagerName, rv);
            }
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(CacheManager cacheManager) {
        Map<String, NonstopExecutorService> map = this.executorServiceMap;
        synchronized (map) {
            NonstopExecutorService executorService = this.executorServiceMap.remove(cacheManager.getName());
            if (executorService != null) {
                executorService.shutdown();
            }
        }
    }
}

