/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLAlertX;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLHandshake;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLopaque;
import COM.claymoresystems.ptls.SSLv3Finished;
import COM.claymoresystems.ptls.TLSFinished;
import cryptix.util.core.ArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class SSLFinished
extends SSLPDU {
    SSLopaque finished;
    byte[] value;

    public SSLFinished(SSLConn conn, SSLHandshake hs, boolean mine) {
        switch (conn.ssl_version) {
            case 768: {
                this.value = SSLv3Finished.computeFinished(hs, mine);
                break;
            }
            case 769: {
                this.value = TLSFinished.computeFinished(hs, mine);
                break;
            }
            default: {
                throw new Error("Unsupported version");
            }
        }
        this.finished = new SSLopaque(this.value.length);
    }

    public int encode(SSLConn conn, OutputStream s) throws Error, IOException {
        this.finished.value = this.value;
        return this.finished.encode(conn, s);
    }

    public int decode(SSLConn conn, InputStream s) throws IOException {
        int rb = this.finished.decode(conn, s);
        if (!ArrayUtil.areEqual((byte[])this.value, (byte[])this.finished.value)) {
            conn.alert(SSLAlertX.TLS_ALERT_BAD_RECORD_MAC);
        }
        return rb;
    }
}

