/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.contexts;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class GCUBEContext {
    protected final GCUBELog logger = new GCUBELog(this);
    private Context JNDIcontext;
    protected Map<Thread, Long> timers = Collections.synchronizedMap(new WeakHashMap());

    public GCUBEContext() {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("org.apache.naming.synchronization", "true");
            env.put("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            this.JNDIcontext = new InitialContext(env);
        }
        catch (Exception e) {
            this.logger.fatal("Could not initialise JNDI context", e);
        }
        this.logger.setContext(this);
    }

    protected Context getJNDIContext() {
        return this.JNDIcontext;
    }

    protected void setJNDIContext(Context jndiContext) {
        this.JNDIcontext = jndiContext;
    }

    public Object getProperty(String prop, boolean ... required) throws RuntimeException {
        try {
            return this.getJNDIContext().lookup(prop);
        }
        catch (Exception e) {
            String msg = "Configuration property '" + prop + "' does not exist or could not be processed";
            if (required.length > 0 && required[0]) {
                throw new RuntimeException(msg, e);
            }
            if (!NameNotFoundException.class.isAssignableFrom(e.getClass())) {
                this.logger.warn(msg, e);
            }
            return null;
        }
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public InputStream getResource(String resourceName) {
        return this.getClass().getResourceAsStream(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getFile(String path, boolean ... writeMode) throws IllegalArgumentException {
        File backup;
        boolean toWrite = writeMode == null || writeMode.length == 0 ? false : writeMode[0];
        File file = new File(path);
        if (toWrite) {
            if (file.isDirectory()) {
                throw new IllegalArgumentException("Path is to a folder");
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                String line;
                if (!file.exists()) return file;
                reader = new BufferedReader(new FileReader(file));
                writer = new BufferedWriter(new FileWriter(new File(file.getAbsolutePath() + ".backup")));
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                }
                return file;
            }
            catch (Exception e) {
                this.logger.warn("Could not create backup of " + file.getAbsolutePath(), e);
                return file;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception shrug) {}
            }
        }
        if (file.exists() && file.length() != 0L || !(backup = new File(file.getAbsolutePath() + ".backup")).exists()) return file;
        backup.renameTo(file);
        return file;
    }

    public static void debugContext(Context ctxt, String ... indent) throws Exception {
        GCUBELog classLogger = new GCUBELog(GCUBEContext.class);
        String spaces = indent == null || indent.length == 0 ? "" : indent[0] + "   ";
        NamingEnumeration<Binding> bindings = ctxt.listBindings("/");
        while (bindings.hasMoreElements()) {
            Binding binding = (Binding)bindings.nextElement();
            Object value = binding.getObject();
            if (Context.class.isAssignableFrom(value.getClass())) {
                classLogger.debug(spaces + binding.getName() + "->");
                GCUBEContext.debugContext((Context)value, spaces);
                continue;
            }
            classLogger.debug(spaces + binding.getName() + "(" + binding.getClassName() + ")->" + value);
        }
    }

    public static void printContext(Context context) {
        GCUBELog classLogger = new GCUBELog(GCUBEContext.class);
        classLogger.debug(context);
        try {
            for (Object key : context.getEnvironment().keySet()) {
                classLogger.debug("Key: " + key);
                classLogger.debug("Value: " + context.getEnvironment().get(key));
            }
            GCUBEContext.debugContext(context, new String[0]);
        }
        catch (Exception e) {
            classLogger.error("Failed to get the JNDI env", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getTiming() {
        Thread t = Thread.currentThread();
        long now = Calendar.getInstance().getTimeInMillis();
        Map<Thread, Long> map = this.timers;
        synchronized (map) {
            if (this.timers.get(t) == null) {
                this.timers.put(t, now);
            }
        }
        return (float)(now - this.timers.get(t)) / 1000.0f;
    }

    public void resetTimer() {
        this.timers.remove(Thread.currentThread());
    }
}

