/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.handlers;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.handlers.GCUBEIHandler;
import org.gcube.common.core.utils.handlers.events.Event;
import org.gcube.common.core.utils.handlers.events.Monitor;
import org.gcube.common.core.utils.handlers.events.Topic;
import org.gcube.common.core.utils.handlers.lifetime.State;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class GCUBEHandler<HANDLED>
implements GCUBEIHandler<HANDLED> {
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
    protected GCUBELog logger = new GCUBELog(this);
    private String id = uuidGen.nextUUID();
    private String name = this.getClass().getSimpleName();
    protected HANDLED handled;
    private Map<String, Object> blackboard = new HashMap<String, Object>();
    State state = State.Created.INSTANCE;
    protected GCUBEProducer<Topic, Object> producer = new GCUBEProducer();
    private GCUBEScopeManager scopeManager;
    private GCUBESecurityManager securityManager;

    public GCUBEHandler() {
    }

    public GCUBEHandler(HANDLED handled) {
        this.setHandled(handled);
    }

    @Override
    public void setLogger(GCUBELog logger) {
        this.logger = logger;
    }

    @Override
    public GCUBELog getLogger() {
        return this.logger;
    }

    @Override
    public abstract void run() throws Exception;

    @Override
    public HANDLED getHandled() {
        return this.handled;
    }

    @Override
    public void setHandled(HANDLED handled) {
        this.handled = handled;
    }

    @Override
    public Map<String, Object> getBlackboard() {
        return this.blackboard;
    }

    @Override
    public void setBlackboard(Map<String, Object> state) {
        this.blackboard = state;
    }

    @Override
    public void clearBlackboard() {
        this.blackboard.clear();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void undo() {
    }

    @Override
    public void subscribe(Monitor monitor, Topic ... topics) {
        GCUBETopic[] gCUBETopicArray;
        if (topics.length == 0) {
            Topic[] topicArray = new Topic[1];
            gCUBETopicArray = topicArray;
            topicArray[0] = Topic.LifetimeTopic.INSTANCE;
        } else {
            gCUBETopicArray = topics;
        }
        this.producer.subscribe(monitor, gCUBETopicArray);
    }

    @Override
    public void unsubscribe(Monitor monitor, Topic ... topics) {
        GCUBETopic[] gCUBETopicArray;
        if (topics.length == 0) {
            Topic[] topicArray = new Topic[1];
            gCUBETopicArray = topicArray;
            topicArray[0] = Topic.LifetimeTopic.INSTANCE;
        } else {
            gCUBETopicArray = topics;
        }
        this.producer.unsubscribe(monitor, gCUBETopicArray);
    }

    protected <TOPIC extends Topic> void notify(TOPIC topic, Event<TOPIC, ?> e) {
        this.producer.notify(topic, e);
    }

    private void notify(Event.LifetimeEvent e) {
        e.setPayload(this);
        this.producer.notify(Topic.LifetimeTopic.INSTANCE, e);
    }

    public synchronized State getState() {
        return this.state;
    }

    public synchronized void setState(State state) throws IllegalArgumentException, IllegalStateException {
        if (state == null) {
            throw new IllegalArgumentException();
        }
        if (this.state.getClass().isAssignableFrom(state.getClass())) {
            return;
        }
        boolean found = false;
        for (State s : state.getPrevious()) {
            if (!s.getClass().isAssignableFrom(this.state.getClass())) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("could not move from " + this.state + " to " + state);
        }
        try {
            try {
                this.state.onExit();
            }
            catch (Exception e) {
                if (!(state instanceof State.Failed)) {
                    throw e;
                }
                this.logger.warn("could not exit from " + this.state + " on failing", e);
            }
            this.state = state;
            Event.LifetimeEvent ltEvent = state.getLifetimeEvent();
            if (ltEvent != null) {
                this.notify(ltEvent);
            }
            this.state.onEnter();
        }
        catch (Exception e) {
            if (state instanceof State.Failed) {
                this.logger.warn("could not move to " + state + ", forcing it.", e);
                this.state = State.Failed.INSTANCE;
            }
            this.logger.error("could not move to " + state, e);
            this.setState(State.Failed.INSTANCE);
        }
    }

    @Override
    public void setSecurityManager(GCUBESecurityManager manager) {
        this.securityManager = manager;
    }

    @Override
    public void setScopeManager(GCUBEScopeManager manager) {
        this.scopeManager = manager;
    }

    @Override
    public GCUBESecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public GCUBEScopeManager getScopeManager() {
        return this.scopeManager;
    }
}

