/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class CaseInsensitiveProperties
extends Properties {
    public CaseInsensitiveProperties(Properties defaults) {
        this.loadProperties(defaults);
    }

    public CaseInsensitiveProperties() {
    }

    public String getProperty(String key) {
        return super.getProperty(key.toLowerCase());
    }

    public String getProperty(String key, String defaultValue) {
        return super.getProperty(key.toLowerCase(), defaultValue);
    }

    public Object setProperty(String key, String value) {
        return super.setProperty(key.toLowerCase(), value);
    }

    public void load(InputStream inputStream) throws IOException {
        Properties tempProperties = new Properties();
        tempProperties.load(inputStream);
        this.loadProperties(tempProperties);
    }

    public void loadProperties(Properties inProperties) {
        Enumeration<?> names = inProperties.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            this.setProperty(key, inProperties.getProperty(key));
        }
        Properties table = inProperties;
        Enumeration setNames = ((Hashtable)table).keys();
        while (setNames.hasMoreElements()) {
            String key = (String)setNames.nextElement();
            this.setProperty(key, inProperties.getProperty(key));
        }
    }

    public Object remove(Object keyObj) throws IllegalArgumentException {
        if (!(keyObj instanceof String)) {
            throw new IllegalArgumentException("CaseInsensitiveProperties.remove accepts only Strings as argument");
        }
        String key = (String)keyObj;
        return super.remove(key.toLowerCase());
    }
}

