/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.informationsystem.client.impl;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AbstractXMLResult
implements XMLResult {
    GCUBELog logger = new GCUBELog(AbstractXMLResult.class);
    protected static XPath engine = XPathFactory.newInstance().newXPath();
    protected static DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
    protected static Transformer transformer;
    protected String result;
    protected Node dom;

    public AbstractXMLResult(String result) throws XMLResult.ISResultInitialisationException {
        try {
            if (transformer == null) {
                transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                domFactory.setNamespaceAware(false);
            }
        }
        catch (Exception e) {
            this.logger.error("Could not initialise XML transformer");
        }
        this.result = result;
    }

    protected void parse(String result) throws ISClient.ISMalformedResultException {
        try {
            this.dom = domFactory.newDocumentBuilder().parse(new InputSource(new StringReader(result))).getDocumentElement();
        }
        catch (Exception e) {
            throw new ISClient.ISMalformedResultException(e);
        }
    }

    @Override
    public String toString() {
        return this.result;
    }

    @Override
    public List<String> evaluate(String xpath) throws XMLResult.ISResultEvaluationException {
        try {
            if (this.dom == null) {
                this.parse(this.result);
            }
            ArrayList<String> results = new ArrayList<String>();
            NodeList set = (NodeList)engine.evaluate(xpath, this.dom, XPathConstants.NODESET);
            for (int i = 0; i < set.getLength(); ++i) {
                StreamResult sr = new StreamResult(new StringWriter());
                try {
                    transformer.transform(new DOMSource(set.item(i)), sr);
                }
                catch (Exception ignore) {
                    continue;
                }
                results.add(sr.getWriter().toString());
            }
            return results;
        }
        catch (Exception e) {
            this.logger.warn("Could not evaluate xpath on result:/n" + this.toString(), e);
            throw new XMLResult.ISResultEvaluationException(e);
        }
    }
}

