/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.lifetime;

import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceHome;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceLifetime;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.TopicListAccessor;
import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.utils.FaultHelper;
import org.globus.wsrf.utils.Resources;
import org.oasis.wsrf.lifetime.ResourceUnknownFaultType;
import org.oasis.wsrf.lifetime.SetTerminationTime;
import org.oasis.wsrf.lifetime.SetTerminationTimeResponse;
import org.oasis.wsrf.lifetime.TerminationNotification;
import org.oasis.wsrf.lifetime.TerminationTimeChangeRejectedFaultType;
import org.oasis.wsrf.lifetime.UnableToSetTerminationTimeFaultType;

public class SetTerminationTimeProvider {
    private static I18n i18n = I18n.getI18n(Resources.class.getName());
    private static Log logger = LogFactory.getLog(SetTerminationTimeProvider.class.getName());
    private static final List TERMINATION_TOPIC_PATH = new Vector(1);

    public SetTerminationTimeResponse setTerminationTime(SetTerminationTime request) throws RemoteException, UnableToSetTerminationTimeFaultType, ResourceUnknownFaultType, TerminationTimeChangeRejectedFaultType {
        if (request == null) {
            UnableToSetTerminationTimeFaultType fault = new UnableToSetTerminationTimeFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.setDescription(i18n.getMessage("nullArgument", "request"));
            throw fault;
        }
        Resource resource = null;
        ResourceHome home = null;
        ResourceKey key = null;
        try {
            ResourceContext ctx = ResourceContext.getResourceContext();
            home = ctx.getResourceHome();
            key = ctx.getResourceKey();
            resource = home.find(key);
        }
        catch (NoSuchResourceException e) {
            ResourceUnknownFaultType fault = new ResourceUnknownFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.setDescription(i18n.getMessage("resourceDisoveryFailed"));
            faultHelper.addFaultCause(e);
            throw fault;
        }
        catch (Exception e) {
            throw new RemoteException(i18n.getMessage("resourceDisoveryFailed"), e);
        }
        if (!(resource instanceof ResourceLifetime)) {
            UnableToSetTerminationTimeFaultType fault = new UnableToSetTerminationTimeFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.setDescription(i18n.getMessage("rltNotSupported"));
            throw fault;
        }
        Calendar termTime = request.getRequestedTerminationTime();
        Calendar currentTime = Calendar.getInstance();
        Calendar newTermTime = null;
        if (termTime != null && termTime.getTime().before(currentTime.getTime())) {
            try {
                home.remove(key);
            }
            catch (NoSuchResourceException e) {
                ResourceUnknownFaultType fault = new ResourceUnknownFaultType();
                FaultHelper faultHelper = new FaultHelper(fault);
                faultHelper.addFaultCause(e);
                throw fault;
            }
            catch (Exception e) {
                UnableToSetTerminationTimeFaultType fault = new UnableToSetTerminationTimeFaultType();
                FaultHelper faultHelper = new FaultHelper(fault);
                faultHelper.setDescription(i18n.getMessage("resourceRemoveFailed"));
                faultHelper.addFaultCause(e);
                throw fault;
            }
            newTermTime = currentTime;
        } else {
            ((ResourceLifetime)((Object)resource)).setTerminationTime(termTime);
            newTermTime = termTime;
        }
        SetTerminationTimeResponse response = new SetTerminationTimeResponse();
        response.setCurrentTime(currentTime);
        response.setNewTerminationTime(newTermTime);
        return response;
    }

    public static void sendTerminationNotification(Object resource) {
        SetTerminationTimeProvider.sendTerminationNotification(resource, null);
    }

    public static void sendTerminationNotification(Object resource, Calendar currentTime) {
        TopicList topicList;
        Topic terminationTopic;
        if (resource instanceof TopicListAccessor && (terminationTopic = (topicList = ((TopicListAccessor)resource).getTopicList()).getTopic(TERMINATION_TOPIC_PATH)) != null) {
            TerminationNotification terminationNotification = new TerminationNotification();
            if (currentTime == null) {
                currentTime = Calendar.getInstance();
            }
            terminationNotification.setTerminationTime(currentTime);
            try {
                terminationTopic.notify(terminationNotification);
            }
            catch (Exception e) {
                logger.error("", e);
            }
        }
    }

    static {
        TERMINATION_TOPIC_PATH.add(WSRFConstants.TERMINATION_TOPIC);
    }
}

