/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import javax.xml.namespace.QName;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.descriptor.CredentialParamsParserCallback;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptorException;
import org.globus.wsrf.impl.security.descriptor.util.ElementHandler;
import org.globus.wsrf.impl.security.descriptor.util.ElementParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CredentialParamsParser
implements ElementHandler {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.descriptor.errors");
    public static final String PROXY_FILE_NAME = "proxy-file";
    public static final String CREDENTIAL_NAME = "credential";
    public static final String KEY_FILE_NAME = "key-file";
    public static final String CERT_FILE_NAME = "cert-file";
    public static final String ATTRIB_NAME = "value";
    public static final QName PROXY_FILE_QNAME = new QName("http://www.globus.org", "proxy-file");
    public static final QName CREDENTIAL_QNAME = new QName("http://www.globus.org", "credential");
    protected CredentialParamsParserCallback callback;

    public CredentialParamsParser(CredentialParamsParserCallback callback) {
        this.callback = callback;
    }

    public void parse(Element elem) throws ElementParserException {
        String name = elem.getLocalName();
        if (name.equalsIgnoreCase(PROXY_FILE_NAME)) {
            this.callback.setProxyFilename(elem.getAttribute(ATTRIB_NAME));
        } else if (name.equalsIgnoreCase(CREDENTIAL_NAME)) {
            String certFile = null;
            String keyFile = null;
            int i = 0;
            for (Node childElem = elem.getFirstChild(); childElem != null; childElem = childElem.getNextSibling()) {
                if (childElem.getNodeType() != 1) continue;
                if (childElem.getLocalName().equalsIgnoreCase(CERT_FILE_NAME)) {
                    certFile = ((Element)childElem).getAttribute(ATTRIB_NAME);
                    ++i;
                } else if (childElem.getLocalName().equalsIgnoreCase(KEY_FILE_NAME)) {
                    keyFile = ((Element)childElem).getAttribute(ATTRIB_NAME);
                    ++i;
                }
                if (i == 2) break;
            }
            if (i != 2) {
                throw new SecurityDescriptorException(i18n.getMessage("badCredElem"));
            }
            this.callback.setCertificateFiles(certFile, keyFile);
        }
    }
}

