/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.container;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.activemq.kaha.ContainerId;
import org.apache.activemq.kaha.RuntimeStoreException;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.index.DiskIndexLinkedList;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexLinkedList;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.apache.activemq.kaha.impl.index.VMIndexLinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseContainerImpl {
    private static final Log LOG = LogFactory.getLog(BaseContainerImpl.class);
    protected IndexItem root;
    protected IndexLinkedList indexList;
    protected IndexManager indexManager;
    protected DataManager dataManager;
    protected ContainerId containerId;
    protected boolean loaded;
    protected boolean closed;
    protected boolean initialized;
    protected boolean persistentIndex;

    protected BaseContainerImpl(ContainerId id, IndexItem root, IndexManager indexManager, DataManager dataManager, boolean persistentIndex) {
        this.containerId = id;
        this.root = root;
        this.indexManager = indexManager;
        this.dataManager = dataManager;
        this.persistentIndex = persistentIndex;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public synchronized void init() {
        if (!this.initialized && !this.initialized) {
            this.initialized = true;
            if (this.indexList == null) {
                this.indexList = this.persistentIndex ? new DiskIndexLinkedList(this.indexManager, this.root) : new VMIndexLinkedList(this.root);
            }
        }
    }

    public synchronized void clear() {
        if (this.indexList != null) {
            this.indexList.clear();
        }
    }

    public IndexLinkedList getList() {
        return this.indexList;
    }

    public void setList(IndexLinkedList indexList) {
        this.indexList = indexList;
    }

    public abstract void unload();

    public abstract void load();

    public abstract int size();

    protected abstract Object getValue(StoreEntry var1);

    protected abstract void remove(IndexItem var1);

    protected final synchronized IndexLinkedList getInternalList() {
        return this.indexList;
    }

    public final synchronized void close() {
        this.unload();
        this.closed = true;
    }

    public final synchronized boolean isLoaded() {
        this.checkClosed();
        return this.loaded;
    }

    public final Object getId() {
        this.checkClosed();
        return this.containerId.getKey();
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public final synchronized void expressDataInterest() throws IOException {
        long nextItem = this.root.getNextItem();
        while (nextItem != -1L) {
            IndexItem item = this.indexManager.getIndex(nextItem);
            item.setOffset(nextItem);
            this.dataManager.addInterestInFile(item.getKeyFile());
            this.dataManager.addInterestInFile(item.getValueFile());
            nextItem = item.getNextItem();
        }
    }

    protected final void doClear() {
        this.checkClosed();
        this.loaded = true;
        ArrayList<IndexItem> indexList = new ArrayList<IndexItem>();
        try {
            this.init();
            long nextItem = this.root.getNextItem();
            while (nextItem != -1L) {
                IndexItem item = new IndexItem();
                item.setOffset(nextItem);
                indexList.add(item);
                nextItem = item.getNextItem();
            }
            this.root.setNextItem(-1L);
            this.storeIndex(this.root);
            for (int i = 0; i < indexList.size(); ++i) {
                IndexItem item = (IndexItem)indexList.get(i);
                this.dataManager.removeInterestInFile(item.getKeyFile());
                this.dataManager.removeInterestInFile(item.getValueFile());
                this.indexManager.freeIndex(item);
            }
            indexList.clear();
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to clear Container " + this.getId()), (Throwable)e);
            throw new RuntimeStoreException(e);
        }
    }

    protected final void delete(IndexItem keyItem, IndexItem prevItem, IndexItem nextItem) {
        if (keyItem != null) {
            try {
                this.root = this.indexList.getRoot();
                IndexItem prev = prevItem == null ? this.root : prevItem;
                IndexItem next = nextItem == null || !nextItem.equals(this.root) ? nextItem : null;
                this.dataManager.removeInterestInFile(keyItem.getKeyFile());
                this.dataManager.removeInterestInFile(keyItem.getValueFile());
                if (next != null) {
                    prev.setNextItem(next.getOffset());
                    next.setPreviousItem(prev.getOffset());
                    this.updateIndexes(next);
                } else {
                    prev.setNextItem(-1L);
                }
                this.updateIndexes(prev);
                this.indexManager.freeIndex(keyItem);
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to delete " + keyItem), (Throwable)e);
                throw new RuntimeStoreException(e);
            }
        }
    }

    protected final void checkClosed() {
        if (this.closed) {
            throw new RuntimeStoreException("The store is closed");
        }
    }

    protected void storeIndex(IndexItem item) throws IOException {
        this.indexManager.storeIndex(item);
    }

    protected void updateIndexes(IndexItem item) throws IOException {
        this.indexManager.updateIndexes(item);
    }

    protected final boolean isRoot(StoreEntry item) {
        return item != null && this.root != null && (this.root == item || this.root.getOffset() == item.getOffset());
    }
}

