/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.virtual;

import java.util.Collection;
import java.util.Iterator;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFilter;
import org.apache.activemq.broker.region.virtual.FilteredDestination;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.filter.NonCachedMessageEvaluationContext;

public class CompositeDestinationFilter
extends DestinationFilter {
    private Collection forwardDestinations;
    private boolean forwardOnly;
    private boolean copyMessage;

    public CompositeDestinationFilter(Destination next, Collection forwardDestinations, boolean forwardOnly, boolean copyMessage) {
        super(next);
        this.forwardDestinations = forwardDestinations;
        this.forwardOnly = forwardOnly;
        this.copyMessage = copyMessage;
    }

    public void send(ProducerBrokerExchange context, Message message) throws Exception {
        NonCachedMessageEvaluationContext messageContext = null;
        Iterator iter = this.forwardDestinations.iterator();
        while (iter.hasNext()) {
            Message forwarded_message;
            ActiveMQDestination destination = null;
            Object value = iter.next();
            if (value instanceof FilteredDestination) {
                FilteredDestination filteredDestination = (FilteredDestination)value;
                if (messageContext == null) {
                    messageContext = new NonCachedMessageEvaluationContext();
                    ((MessageEvaluationContext)messageContext).setMessageReference(message);
                }
                messageContext.setDestination(filteredDestination.getDestination());
                if (filteredDestination.matches(messageContext)) {
                    destination = filteredDestination.getDestination();
                }
            } else if (value instanceof ActiveMQDestination) {
                destination = (ActiveMQDestination)value;
            }
            if (destination == null) continue;
            if (this.copyMessage) {
                forwarded_message = message.copy();
                forwarded_message.setDestination(destination);
            } else {
                forwarded_message = message;
            }
            this.send(context, forwarded_message, destination);
        }
        if (!this.forwardOnly) {
            super.send(context, message);
        }
    }
}

