/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.handlers.lifetime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gcube.common.core.utils.handlers.events.Event;

public abstract class State {
    private List<State> previous;

    protected State() {
    }

    protected abstract void addPrevious(List<State> var1);

    public final synchronized List<State> getPrevious() {
        if (this.previous == null) {
            this.previous = new ArrayList<State>();
            this.addPrevious(this.previous);
        }
        return this.previous;
    }

    public String toString() {
        return this.getClass().getSimpleName().toUpperCase();
    }

    public void onEnter() throws Exception {
    }

    public void onExit() throws Exception {
    }

    public Event.LifetimeEvent getLifetimeEvent() {
        return null;
    }

    public boolean equals(Object o) {
        return this.getClass().equals(o.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Failed
    extends State {
        public static final Failed INSTANCE = new Failed();

        @Override
        protected void addPrevious(List<State> previous) {
            previous.addAll(Arrays.asList(Created.INSTANCE, Running.INSTANCE, Suspended.INSTANCE));
        }

        @Override
        public Event.LifetimeEvent getLifetimeEvent() {
            return new Event.Failed();
        }
    }

    public static class Done
    extends State {
        public static final Done INSTANCE = new Done();

        protected Done() {
        }

        @Override
        protected void addPrevious(List<State> previous) {
            previous.addAll(Arrays.asList(Running.INSTANCE, Suspended.INSTANCE));
        }

        @Override
        public Event.LifetimeEvent getLifetimeEvent() {
            return new Event.Done();
        }
    }

    public static class Suspended
    extends State {
        public static final Suspended INSTANCE = new Suspended();

        protected Suspended() {
        }

        @Override
        protected void addPrevious(List<State> previous) {
            previous.add(Running.INSTANCE);
        }

        @Override
        public Event.LifetimeEvent getLifetimeEvent() {
            return new Event.Suspended();
        }
    }

    public static class Running
    extends State {
        public static final Running INSTANCE = new Running();

        protected Running() {
        }

        @Override
        protected void addPrevious(List<State> previous) {
            previous.addAll(Arrays.asList(Created.INSTANCE, Suspended.INSTANCE, Done.INSTANCE));
        }

        @Override
        public Event.LifetimeEvent getLifetimeEvent() {
            return new Event.Running();
        }
    }

    public static class Created
    extends State {
        public static final Created INSTANCE = new Created();

        @Override
        protected void addPrevious(List<State> previous) {
        }
    }
}

