/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.logparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import org.gcube.common.accounting.node.logparser.LogEntry;
import org.gcube.common.accounting.node.util.DateInterval;
import org.gcube.common.accounting.node.util.Util;

public class RIInvocationParser {
    private String fileName;
    private static String invalidScope = "INVALID";
    private DateInterval interval;
    private ArrayList<LogEntry> entryList = new ArrayList();

    public RIInvocationParser() {
    }

    public RIInvocationParser(String fileName) {
        this.fileName = fileName;
        this.interval = new DateInterval(new Long(0L));
    }

    public RIInvocationParser(String fileName, DateInterval interval) {
        this.fileName = fileName;
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException, ParseException {
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new FileReader(new File(this.fileName)));
            while ((line = reader.readLine()) != null) {
                LogEntry entry = this.parseLine(line);
                if (entry == null) continue;
                this.entryList.add(entry);
            }
        }
    }

    private LogEntry parseLine(String line) throws ParseException {
        String time;
        LogEntry entry = null;
        if (line.contains(EntryType.ENDCALL.type) && !line.contains(invalidScope) && this.interval.contains(Util.format.parse(time = line.substring(0, line.indexOf(",")))).booleanValue()) {
            entry = new LogEntry(EntryType.ENDCALL, line.substring(line.indexOf(EntryType.ENDCALL.type)), time);
        }
        return entry;
    }

    public ArrayList<LogEntry> getEntryList() {
        return this.entryList;
    }

    public void setEntryList(ArrayList<LogEntry> entryList) {
        this.entryList = entryList;
    }

    public static enum EntryType {
        ENDCALL("END CALL"),
        STARTCALL("START CALL");

        String type;

        private EntryType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

