/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.proxies;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.core.utils.proxies.GCUBEProxyContext;
import org.gcube.common.core.utils.proxies.GCUBEProxyFactory;

public class ReadOnlyProxyContext
extends GCUBEProxyContext<ReadOnly> {
    protected List<String> prefixes = new ArrayList<String>();

    @Override
    public Class<ReadOnly> getAnnotationClass() {
        return ReadOnly.class;
    }

    @Override
    public MethodInterceptor getInterceptor(final Object proxied) {
        GCUBELog logger = new GCUBELog(this);
        return new MethodInterceptor(){

            public Object intercept(Object proxy, Method method, Object[] input, MethodProxy methodProxy) throws Throwable {
                Object object;
                String name = method.getName();
                for (String prefix : ReadOnlyProxyContext.this.getPrefixes()) {
                    if (!name.startsWith(prefix.toLowerCase())) continue;
                    boolean allowed = false;
                    for (String allowable : ((ReadOnly)ReadOnlyProxyContext.this.getAnnotation()).value()) {
                        if (!ReadOnlyProxyContext.this.getProxyCaller().getClassName().startsWith(allowable)) continue;
                        allowed = true;
                        break;
                    }
                    if (allowed) break;
                    throw new IllegalAccessError("Access to " + method + " is forbidden from " + ReadOnlyProxyContext.this.caller.getClassName());
                }
                if ((object = methodProxy.invoke(proxied, input)) != null && !Modifier.isFinal(object.getClass().getModifiers()) & !object.getClass().isLocalClass() & !object.getClass().isMemberClass()) {
                    ReadOnlyProxyContext returnContext = new ReadOnlyProxyContext();
                    returnContext.setAnnotation(ReadOnlyProxyContext.this.getAnnotation());
                    return GCUBEProxyFactory.getProxy(returnContext, object, new Class[0]);
                }
                return object;
            }
        };
    }

    public synchronized List<String> getPrefixes() {
        if (this.prefixes.size() == 0) {
            this.prefixes.add("put");
            this.prefixes.add("set");
            this.prefixes.add("add");
            this.prefixes.add("remove");
            this.prefixes.add("delete");
        }
        return this.prefixes;
    }

    public synchronized void addWritePrefix(String prefix) {
        this.prefixes.add(prefix);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ReadOnly {
        public String[] value() default {"org.gcube.common"};
    }
}

