/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.state;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.persistence.GCUBENoPersistenceDelegate;
import org.gcube.common.core.persistence.GCUBEPersistenceDelegate;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEReadWriteLock;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.core.utils.handlers.GCUBEServiceClientImpl;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceException;

public abstract class GCUBEStatefulResource<RESOURCEID>
extends GCUBEServiceClientImpl
implements Resource {
    protected static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
    protected final GCUBELog logger = new GCUBELog(this);
    private RESOURCEID id;
    private GCUBEPersistenceDelegate<RESOURCEID, GCUBEStatefulResource<RESOURCEID>> delegate = new GCUBENoPersistenceDelegate();
    private final GCUBEReadWriteLock resourceLock = new GCUBEReadWriteLock();
    private final Map<String, TaskContext> scheduledTasks = Collections.synchronizedMap(new HashMap());

    public RESOURCEID getID() {
        return this.id;
    }

    public void setID(RESOURCEID id) {
        if (this.id != null) {
            throw new RuntimeException("identifier is immutable");
        }
        this.id = id;
    }

    protected abstract void initialise(RESOURCEID var1, Object ... var2) throws Exception;

    public abstract GCUBEServiceContext getServiceContext();

    public void setPersistenceDelegate(GCUBEPersistenceDelegate<RESOURCEID, ? extends GCUBEStatefulResource<RESOURCEID>> delegate) {
        this.delegate = delegate;
    }

    public void store() {
        this.delegate.store(this);
    }

    protected void onRemove() throws ResourceException {
        for (TaskContext context : this.scheduledTasks.values()) {
            context.scheduler.stop();
        }
    }

    public GCUBEReadWriteLock getLock() {
        return this.resourceLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void launchTask(final String taskName, GCUBEHandler<T> task, Long delay, GCUBEScheduledHandler.Mode mode) throws Exception {
        Map<String, TaskContext> map = this.scheduledTasks;
        synchronized (map) {
            String msg;
            TaskContext context = this.scheduledTasks.get(taskName);
            if (context != null) {
                if (context.scheduler != null) {
                    this.logger.warn("task " + taskName + " for " + this.getID() + " running already");
                    return;
                }
                msg = "restarting";
                this.getServiceContext().setScope(context.scope);
            } else {
                msg = "launching";
                context = new TaskContext();
                context.scope = this.getScope();
            }
            this.logger.info(msg + " task " + taskName + " for " + this.getID() + " in scope " + context.scope);
            GCUBEScheduledHandler scheduler = new GCUBEScheduledHandler<T>(delay, mode, new GCUBEHandler[0]){

                @Override
                protected boolean repeat(Exception exception, int exceptionCount) {
                    if (exception != null) {
                        this.logger.warn("could not execute scheduled task " + taskName + " (failure num." + exceptionCount + ")", exception);
                    }
                    return true;
                }
            };
            scheduler.setSecurityManager(this.getServiceContext());
            scheduler.setScopeManager(this.getServiceContext());
            scheduler.setScheduled(task);
            try {
                scheduler.run();
                context.scheduler = scheduler;
                this.scheduledTasks.put(taskName, context);
            }
            catch (Exception e) {
                this.logger.error("task " + taskName + " for " + this.getID() + " could not be launched", e);
                throw e;
            }
        }
    }

    public Map<String, TaskContext> getScheduledTasks() {
        return this.scheduledTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTask(String taskName) throws Exception {
        Map<String, TaskContext> map = this.scheduledTasks;
        synchronized (map) {
            this.logger.info("stopping " + taskName + " for " + this.getID());
            GCUBEScheduledHandler<?> task = this.scheduledTasks.get((Object)taskName).scheduler;
            if (task == null) {
                this.logger.warn("task " + taskName + " for " + this.getID() + " could not be stopped because it does not exist");
            } else {
                task.stop();
                this.scheduledTasks.remove(taskName);
            }
        }
    }

    @Override
    public GCUBEScope getScope() {
        String currentScope = ScopeProvider.instance.get();
        return currentScope == null ? null : GCUBEScope.getScope(currentScope);
    }

    public static class TaskContext
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public GCUBEScheduledHandler<?> scheduler;
        public GCUBEScope scope;

        TaskContext() {
        }

        public TaskContext(GCUBEScheduledHandler<?> handler, GCUBEScope scope) {
            this.scheduler = handler;
            this.scope = scope;
        }
    }

    public static enum LOCK {
        READ,
        WRITE;

    }
}

