/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.virtual;

import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFilter;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.Message;

public class VirtualTopicInterceptor
extends DestinationFilter {
    private String prefix;
    private String postfix;

    public VirtualTopicInterceptor(Destination next, String prefix, String postfix) {
        super(next);
        this.prefix = prefix;
        this.postfix = postfix;
    }

    public void send(ProducerBrokerExchange context, Message message) throws Exception {
        ActiveMQDestination queueConsumers = this.getQueueConsumersWildcard(message.getDestination());
        this.send(context, message, queueConsumers);
        super.send(context, message);
    }

    protected ActiveMQDestination getQueueConsumersWildcard(ActiveMQDestination original) {
        return new ActiveMQQueue(this.prefix + original.getPhysicalName() + this.postfix);
    }
}

