/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tomcat.catalina.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.globus.common.ChainedIOException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.tomcat.catalina.net.HTTPSSocket;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class BaseHTTPSServerSocketFactory
extends ServerSocketFactory {
    public static final String PROXY_FILE = "proxy";
    public static final String CERT_FILE = "cert";
    public static final String KEY_FILE = "key";
    public static final String CA_CERT_DIR = "cACertDir";
    public static final String AUTO_FLUSH = "autoFlush";
    private static Logger logger = Logger.getLogger((Class)(class$org$globus$tomcat$catalina$net$BaseHTTPSServerSocketFactory == null ? (class$org$globus$tomcat$catalina$net$BaseHTTPSServerSocketFactory = BaseHTTPSServerSocketFactory.class$("org.globus.tomcat.catalina.net.BaseHTTPSServerSocketFactory")) : class$org$globus$tomcat$catalina$net$BaseHTTPSServerSocketFactory));
    static /* synthetic */ Class class$org$globus$tomcat$catalina$net$BaseHTTPSServerSocketFactory;

    public String getCert() {
        return (String)this.attributes.get(CERT_FILE);
    }

    public void setCert(String serverCert) {
        this.attributes.put(CERT_FILE, serverCert);
    }

    public String getKey() {
        return (String)this.attributes.get(KEY_FILE);
    }

    public void setKey(String serverKey) {
        this.attributes.put(KEY_FILE, serverKey);
    }

    public String getProxy() {
        return (String)this.attributes.get(PROXY_FILE);
    }

    public void setProxy(String serverProxy) {
        this.attributes.put(PROXY_FILE, serverProxy);
    }

    public String getCacertdir() {
        return (String)this.attributes.get(CA_CERT_DIR);
    }

    public void setCacertdir(String caCertDir) {
        this.attributes.put(CA_CERT_DIR, caCertDir);
    }

    public boolean getAutoFlush() {
        String autoFlush = (String)this.attributes.get(AUTO_FLUSH);
        return autoFlush == null ? false : autoFlush.equals("true");
    }

    public void setAutoFlush(boolean autoFlush) {
        this.attributes.put(AUTO_FLUSH, autoFlush ? "true" : "false");
    }

    public ServerSocket createSocket(int port) throws IOException {
        return this.createSocket(port, 50);
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        return this.createSocket(port, backlog, null);
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        GlobusGSSCredentialImpl gssCred = null;
        GlobusCredential cred = null;
        TrustedCertificates trustedCerts = null;
        String serverCert = null;
        String serverKey = null;
        String serverProxy = null;
        String caCertDir = null;
        logger.info((Object)"Loading credentials");
        try {
            serverProxy = (String)this.attributes.get(PROXY_FILE);
            serverCert = (String)this.attributes.get(CERT_FILE);
            serverKey = (String)this.attributes.get(KEY_FILE);
            caCertDir = (String)this.attributes.get(CA_CERT_DIR);
            if (serverProxy != null && !serverProxy.equals("")) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Server Proxy: " + serverProxy));
                }
                cred = new GlobusCredential(serverProxy);
            } else if (serverCert != null && serverKey != null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Server Certificate: " + serverCert));
                    logger.info((Object)("Server Key: " + serverKey));
                }
                cred = new GlobusCredential(serverCert, serverKey);
            }
            if (cred != null) {
                gssCred = new GlobusGSSCredentialImpl(cred, 2);
            }
        }
        catch (GlobusCredentialException e) {
            throw new ChainedIOException("Failed to load credentials", (Throwable)e);
        }
        catch (GSSException e) {
            throw new ChainedIOException("Failed to load credentials", (Throwable)e);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("CA certificate directory: " + caCertDir));
        }
        if (caCertDir != null) {
            trustedCerts = TrustedCertificates.load((String)caCertDir);
        }
        HTTPSServerSocket serverSocket = this.createServerSocket(port, backlog, bindAddr);
        serverSocket.setCredentials((GSSCredential)gssCred);
        serverSocket.setTrustedCertificates(trustedCerts);
        return serverSocket;
    }

    protected HTTPSServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        return new HTTPSServerSocket(port, backlog, bindAddr);
    }

    public Socket acceptSocket(ServerSocket socket) throws IOException {
        return socket.accept();
    }

    public void handshake(Socket sock) throws IOException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class HTTPSServerSocket
    extends ServerSocket {
        protected TrustedCertificates _trustedCerts;
        private GSSCredential _credentials;
        private GssSocketFactory _factory = GssSocketFactory.getDefault();
        private GSSManager _manager = ExtendedGSSManager.getInstance();
        private boolean _autoFlush;

        protected HTTPSServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
            super(port, backlog, bindAddr);
            this._autoFlush = BaseHTTPSServerSocketFactory.this.getAutoFlush();
        }

        public void setTrustedCertificates(TrustedCertificates trustedCerts) {
            this._trustedCerts = trustedCerts;
        }

        public void setCredentials(GSSCredential creds) {
            this._credentials = creds;
        }

        public Socket accept() throws IOException {
            Socket s = super.accept();
            ExtendedGSSContext context = null;
            try {
                context = (ExtendedGSSContext)this._manager.createContext(this._credentials);
                this.setContextOptions(context);
            }
            catch (GSSException e) {
                throw new ChainedIOException("Failed to init GSS context", (Throwable)e);
            }
            HTTPSSocket httpsSocket = (HTTPSSocket)((Object)this.createSocket(s, context));
            httpsSocket.setAutoFlush(this._autoFlush);
            httpsSocket.setUseClientMode(false);
            return httpsSocket;
        }

        protected Socket createSocket(Socket s, ExtendedGSSContext context) {
            return new HTTPSSocket(s, (GSSContext)context);
        }

        protected void setContextOptions(ExtendedGSSContext context) throws GSSException {
            context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_SSL);
            context.setOption(GSSConstants.ACCEPT_NO_CLIENT_CERTS, (Object)Boolean.TRUE);
            if (this._trustedCerts != null) {
                logger.info((Object)"Setting trusted certificates");
                context.setOption(GSSConstants.TRUSTED_CERTIFICATES, (Object)this._trustedCerts);
            }
        }
    }
}

