/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.store.record;

import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.store.buffer.CacheBufferStore;
import gr.uoa.di.madgik.grs.store.record.GRS2RecordStoreAccessException;
import gr.uoa.di.madgik.grs.store.record.GRS2RecordStoreException;
import gr.uoa.di.madgik.grs.store.record.IRecordStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.UUID;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;

public class CacheRecordStore
implements IRecordStore {
    private static final int KeepInMemoryDef = 1000;
    private static final MemoryStoreEvictionPolicy EvictionPolicyDef = MemoryStoreEvictionPolicy.FIFO;
    private int keepInMemory = 1000;
    private MemoryStoreEvictionPolicy evictionPolicy = EvictionPolicyDef;
    private Cache cache = null;
    private Cache orderedMappingCache = null;
    private boolean enableOrder = false;
    private long recordCount = 0L;
    private CacheManager manager = CacheBufferStore.manager;
    private UUID id = UUID.randomUUID();
    private String name = "gRSRecordStoreCache" + this.id;
    private String orderedName = "gRSRecordStoreCacheAux" + this.id;

    public CacheRecordStore(int keepInMemory, MemoryStoreEvictionPolicy evictionPolicy) {
        this.cache = new Cache(this.name, keepInMemory, evictionPolicy, true, null, true, 0L, 0L, false, 600L, null);
        this.cache.setName(this.name);
        this.manager.addCache(this.cache);
        if (this.enableOrder) {
            this.orderedMappingCache = new Cache(this.orderedName, keepInMemory, evictionPolicy, true, null, true, 0L, 0L, false, 600L, null);
        }
        this.recordCount = 0L;
        this.keepInMemory = keepInMemory;
        this.evictionPolicy = evictionPolicy;
    }

    public CacheRecordStore(int keepInMemory) {
        this(keepInMemory, EvictionPolicyDef);
    }

    public CacheRecordStore() {
        this(1000, EvictionPolicyDef);
    }

    @Override
    public void enableOrder(boolean enableOrder) {
        if (this.enableOrder && enableOrder) {
            if (enableOrder) {
                this.orderedMappingCache.dispose();
                this.manager.removeCache(this.orderedName);
            }
            this.orderedMappingCache = new Cache(this.orderedName, this.keepInMemory, this.evictionPolicy, true, null, true, 0L, 0L, false, 600L, null);
            this.orderedMappingCache.setName(this.orderedName);
            this.manager.addCache(this.orderedMappingCache);
        }
        this.enableOrder = enableOrder;
        if (!this.enableOrder && this.orderedMappingCache != null) {
            this.orderedMappingCache.dispose();
            this.orderedMappingCache = null;
            this.manager.removeCache(this.orderedName);
        }
    }

    @Override
    public long getRecordCount() {
        return this.cache.getSize();
    }

    @Override
    public void persist(Record record) throws GRS2RecordStoreException {
        try {
            if (this.cache.isElementInMemory((Serializable)Long.valueOf(record.getID()))) {
                return;
            }
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bOut);
            out.writeUTF(record.getClass().getName());
            record.deflate(out);
            this.cache.putQuiet(new Element((Serializable)Long.valueOf(record.getID()), (Serializable)bOut.toByteArray()));
            if (this.enableOrder) {
                this.orderedMappingCache.putQuiet(new Element((Serializable)((Object)Long.valueOf(this.recordCount).toString()), (Serializable)((Object)Long.valueOf(record.getID()).toString())));
            }
            ++this.recordCount;
        }
        catch (Exception e) {
            throw new GRS2RecordStoreAccessException("Could not persist record", e);
        }
    }

    @Override
    public Record retrieve(long recordID, boolean reset) throws GRS2RecordStoreException {
        try {
            Element element = this.cache.getQuiet((Serializable)Long.valueOf(recordID));
            if (element == null) {
                return null;
            }
            byte[] bIn = (byte[])element.getObjectValue();
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bIn));
            String recordType = in.readUTF();
            Record record = (Record)Class.forName(recordType).newInstance();
            record.inflate(in, reset);
            return record;
        }
        catch (Exception e) {
            throw new GRS2RecordStoreAccessException("Could not retrieve record", e);
        }
    }

    @Override
    public Record retrieveByIndex(long recordIndex, boolean reset) throws GRS2RecordStoreException {
        try {
            if (!this.enableOrder) {
                throw new GRS2RecordStoreAccessException("this operation is only available when ordering is enabled");
            }
            Element element = null;
            element = this.orderedMappingCache.getQuiet((Serializable)((Object)Long.valueOf(recordIndex).toString()));
            if (element == null) {
                return null;
            }
            long recId = (Long)element.getValue();
            return this.retrieve(recId, reset);
        }
        catch (Exception e) {
            throw new GRS2RecordStoreAccessException("Could not persist record", e);
        }
    }

    @Override
    public void dispose() throws GRS2RecordStoreException {
        try {
            if (this.orderedMappingCache != null) {
                this.orderedMappingCache.dispose();
                this.orderedMappingCache = null;
                this.manager.removeCache(this.orderedName);
            }
            this.cache.dispose();
            this.cache = null;
            this.manager.removeCache(this.name);
        }
        catch (Exception e) {
            throw new GRS2RecordStoreException("Could not dispose persistency manager resources", e);
        }
    }
}

