/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.validation;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.cli2.resource.ResourceHelper;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;

public class DateValidator
implements Validator {
    private static final ResourceHelper resources = ResourceHelper.getResourceHelper();
    private DateFormat[] formats;
    private Date minimum;
    private Date maximum;
    private boolean isLenient;

    public DateValidator() {
        this(DateFormat.getInstance());
    }

    public DateValidator(DateFormat format) {
        this.setFormat(format);
    }

    public DateValidator(List formats) {
        Iterator iter = formats.iterator();
        while (iter.hasNext()) {
            DateFormat dateFormat = (DateFormat)iter.next();
        }
        this.setFormats(formats);
    }

    public static DateValidator getDateInstance() {
        return new DateValidator(DateFormat.getDateInstance());
    }

    public static DateValidator getTimeInstance() {
        return new DateValidator(DateFormat.getTimeInstance());
    }

    public static DateValidator getDateTimeInstance() {
        return new DateValidator(DateFormat.getDateTimeInstance());
    }

    public void validate(List values) throws InvalidArgumentException {
        ListIterator<Date> i = values.listIterator();
        while (i.hasNext()) {
            String value = (String)i.next();
            Date date = null;
            ParsePosition pp = new ParsePosition(0);
            for (int f = 0; f < this.formats.length && date == null; ++f) {
                pp.setIndex(0);
                date = this.formats[f].parse(value, pp);
                if (pp.getIndex() >= value.length()) continue;
                date = null;
            }
            if (date == null) {
                throw new InvalidArgumentException(value);
            }
            if (this.isDateEarlier(date) || this.isDateLater(date)) {
                throw new InvalidArgumentException(resources.getMessage("DateValidator.date.OutOfRange", value));
            }
            i.set(date);
        }
    }

    public void setLenient(boolean lenient) {
        for (int i = 0; i < this.formats.length; ++i) {
            this.formats[i].setLenient(lenient);
        }
        this.isLenient = lenient;
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    public Date getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Date maximum) {
        this.maximum = maximum;
    }

    public Date getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Date minimum) {
        this.minimum = minimum;
    }

    private boolean isDateLater(Date date) {
        return this.maximum != null && date.getTime() > this.maximum.getTime();
    }

    private boolean isDateEarlier(Date date) {
        return this.minimum != null && date.getTime() < this.minimum.getTime();
    }

    public void setFormat(DateFormat format) {
        this.setFormats(new DateFormat[]{format});
    }

    public void setFormats(List formats) {
        this.setFormats(formats.toArray(new DateFormat[formats.size()]));
    }

    public void setFormats(DateFormat[] formats) {
        this.formats = formats;
        this.setLenient(this.isLenient);
    }

    public DateFormat[] getFormats() {
        return this.formats;
    }
}

