/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.gsi;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;

public class JndiTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        String host = null;
        String binddn = null;
        String baseDN = "mds-vo-name=local, o=grid";
        String filter = "(objectclass=*)";
        String qop = "auth-conf, auth";
        boolean debug = false;
        int port = 389;
        int version = 3;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h")) {
                host = args[++i];
                continue;
            }
            if (args[i].equals("-p")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-ver")) {
                version = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-d")) {
                debug = true;
                continue;
            }
            if (args[i].equals("-D")) {
                binddn = args[++i];
                continue;
            }
            if (args[i].equals("-b")) {
                baseDN = args[++i];
                continue;
            }
            if (args[i].equals("-qop")) {
                qop = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-usage") || args[i].equalsIgnoreCase("-help")) {
                System.err.println("Usage: JndiTest -h [host] -p [port] -D [binddn] [-d] -b [baseDN]");
                System.err.println("\tExample: JndiTest -h mds.globus.org -p 389 -r o=globus,c=us");
                System.exit(1);
                continue;
            }
            System.err.println("Invalid argument: " + args[i]);
            System.exit(1);
        }
        if (host == null) {
            System.err.println("Error: hostname not specified!");
            System.exit(1);
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.ldap.version", String.valueOf(version));
        env.put("java.naming.provider.url", "ldap://" + host + ":" + port);
        env.put("java.naming.security.authentication", "GSS-OWNYQ6NTEOAUVGWG");
        env.put("javax.security.sasl.client.pkgs", "org.globus.mds.gsi.jndi");
        env.put("javax.security.sasl.qop", qop);
        if (binddn != null) {
            env.put("java.naming.security.principal", binddn);
        }
        if (debug) {
            env.put("com.sun.jndi.ldap.trace.ber", System.err);
        }
        InitialDirContext ctx = null;
        ctx = new InitialDirContext(env);
        NamingEnumeration<SearchResult> results = ctx.search(baseDN, filter, null);
        while (results.hasMoreElements()) {
            SearchResult si = results.next();
            Attributes attrs = si.getAttributes();
            System.out.println(si.getName() + ":");
            System.out.println(attrs);
            System.out.println();
        }
        Object var15_16 = null;
        if (ctx == null) return;
        try {
            ctx.close();
            return;
        }
        catch (Exception e2) {}
        return;
        {
            catch (Exception e) {
                System.err.println("JndiTest failed: " + e.getMessage());
                e.printStackTrace();
                Object var15_17 = null;
                if (ctx == null) return;
                try {
                    ctx.close();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            if (ctx == null) throw throwable;
            try {
                ctx.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

