/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tomcat.catalina.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.security.gridmap.GridMap;
import org.globus.tomcat.catalina.net.BaseHTTPSServerSocketFactory;
import org.globus.tomcat.catalina.net.GSISocket;
import org.globus.tomcat.catalina.net.HTTPSServerSocketFactory;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;

public class GSIServerSocketFactory
extends HTTPSServerSocketFactory {
    private String gridMapFile = "/etc/grid-security/grid-mapfile";
    private boolean sslMode = false;
    private static Logger logger = Logger.getLogger((Class)(class$org$globus$tomcat$catalina$net$GSIServerSocketFactory == null ? (class$org$globus$tomcat$catalina$net$GSIServerSocketFactory = GSIServerSocketFactory.class$("org.globus.tomcat.catalina.net.GSIServerSocketFactory")) : class$org$globus$tomcat$catalina$net$GSIServerSocketFactory));
    static /* synthetic */ Class class$org$globus$tomcat$catalina$net$GSIServerSocketFactory;

    public GSIServerSocketFactory() {
        super.setCert("/etc/grid-security/hostcert.pem");
        super.setKey("/etc/grid-security/hostkey.pem");
        super.setCacertdir("/etc/grid-security/certificates");
    }

    public void setGridMap(String file) {
        this.gridMapFile = file;
    }

    public String getGridMap() {
        return this.gridMapFile;
    }

    public void setSslMode(boolean sslMode) {
        this.sslMode = sslMode;
    }

    public boolean getSslMode() {
        return this.sslMode;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        GridMap gridMap = new GridMap();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Loading gridmap file:" + this.gridMapFile));
        }
        gridMap.load(this.gridMapFile);
        GSIServerSocket serverSocket = (GSIServerSocket)super.createSocket(port, backlog, bindAddr);
        serverSocket.setGridMap(gridMap);
        return serverSocket;
    }

    protected BaseHTTPSServerSocketFactory.HTTPSServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        return new GSIServerSocket(port, backlog, bindAddr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class GSIServerSocket
    extends BaseHTTPSServerSocketFactory.HTTPSServerSocket {
        private GridMap _gridMap;

        public GSIServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
            super(port, backlog, bindAddr);
        }

        public void setGridMap(GridMap gridMap) {
            this._gridMap = gridMap;
        }

        public Socket accept() throws IOException {
            GSISocket s = (GSISocket)((Object)super.accept());
            this._gridMap.refresh();
            s.setGridMap(this._gridMap);
            return s;
        }

        protected Socket createSocket(Socket s, ExtendedGSSContext context) {
            return new GSISocket(s, (GSSContext)context);
        }

        protected void setContextOptions(ExtendedGSSContext context) throws GSSException {
            if (GSIServerSocketFactory.this.getSslMode()) {
                logger.info((Object)"Using SSL mode");
                context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_SSL);
            }
            if (this._trustedCerts != null) {
                logger.info((Object)"Setting trusted certificates");
                context.setOption(GSSConstants.TRUSTED_CERTIFICATES, (Object)this._trustedCerts);
            }
        }
    }
}

