/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

class OldPKCS12ParametersGenerator
extends PBEParametersGenerator {
    public static final int KEY_MATERIAL = 1;
    public static final int IV_MATERIAL = 2;
    public static final int MAC_MATERIAL = 3;
    private Digest digest;
    private int u;
    private int v;

    public OldPKCS12ParametersGenerator(Digest digest) {
        this.digest = digest;
        if (digest instanceof MD5Digest) {
            this.u = 16;
            this.v = 64;
        } else if (digest instanceof SHA1Digest) {
            this.u = 20;
            this.v = 64;
        } else if (digest instanceof RIPEMD160Digest) {
            this.u = 20;
            this.v = 64;
        } else {
            throw new IllegalArgumentException("Digest " + digest.getAlgorithmName() + " unsupported");
        }
    }

    private void adjust(byte[] byArray, int n, byte[] byArray2) {
        int n2 = (byArray2[byArray2.length - 1] & 0xFF) + (byArray[n + byArray2.length - 1] & 0xFF) + 1;
        byArray[n + byArray2.length - 1] = (byte)n2;
        n2 >>>= 8;
        int n3 = byArray2.length - 2;
        while (n3 >= 0) {
            byArray[n + n3] = (byte)(n2 += (byArray2[n3] & 0xFF) + (byArray[n + n3] & 0xFF));
            n2 >>>= 8;
            --n3;
        }
    }

    private byte[] generateDerivedKey(int n, int n2) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3 = new byte[this.v];
        byte[] byArray4 = new byte[n2];
        int n3 = 0;
        while (n3 != byArray3.length) {
            byArray3[n3] = (byte)n;
            ++n3;
        }
        if (this.salt != null && this.salt.length != 0) {
            byArray2 = new byte[this.v * ((this.salt.length + this.v - 1) / this.v)];
            int n4 = 0;
            while (n4 != byArray2.length) {
                byArray2[n4] = this.salt[n4 % this.salt.length];
                ++n4;
            }
        } else {
            byArray2 = new byte[]{};
        }
        if (this.password != null && this.password.length != 0) {
            byArray = new byte[this.v * ((this.password.length + this.v - 1) / this.v)];
            int n5 = 0;
            while (n5 != byArray.length) {
                byArray[n5] = this.password[n5 % this.password.length];
                ++n5;
            }
        } else {
            byArray = new byte[]{};
        }
        byte[] byArray5 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray5, byArray2.length, byArray.length);
        byte[] byArray6 = new byte[this.v];
        int n6 = (n2 + this.u - 1) / this.u;
        int n7 = 1;
        while (n7 <= n6) {
            byte[] byArray7 = new byte[this.u];
            this.digest.update(byArray3, 0, byArray3.length);
            this.digest.update(byArray5, 0, byArray5.length);
            this.digest.doFinal(byArray7, 0);
            int n8 = 1;
            while (n8 != this.iterationCount) {
                this.digest.update(byArray7, 0, byArray7.length);
                this.digest.doFinal(byArray7, 0);
                ++n8;
            }
            int n9 = 0;
            while (n9 != byArray6.length) {
                byArray6[n7] = byArray7[n9 % byArray7.length];
                ++n9;
            }
            int n10 = 0;
            while (n10 != byArray5.length / this.v) {
                this.adjust(byArray5, n10 * this.v, byArray6);
                ++n10;
            }
            if (n7 == n6) {
                System.arraycopy(byArray7, 0, byArray4, (n7 - 1) * this.u, byArray4.length - (n7 - 1) * this.u);
            } else {
                System.arraycopy(byArray7, 0, byArray4, (n7 - 1) * this.u, byArray7.length);
            }
            ++n7;
        }
        return byArray4;
    }

    public CipherParameters generateDerivedParameters(int n) {
        byte[] byArray = this.generateDerivedKey(1, n /= 8);
        return new KeyParameter(byArray, 0, n);
    }

    public CipherParameters generateDerivedParameters(int n, int n2) {
        byte[] byArray = this.generateDerivedKey(1, n /= 8);
        byte[] byArray2 = this.generateDerivedKey(2, n2 /= 8);
        return new ParametersWithIV(new KeyParameter(byArray, 0, n), byArray2, 0, n2);
    }

    public CipherParameters generateDerivedMacParameters(int n) {
        byte[] byArray = this.generateDerivedKey(3, n /= 8);
        return new KeyParameter(byArray, 0, n);
    }
}

