/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.resultset;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.security.PrivateKey;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.xml.transform.Templates;
import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.CloneThreadGeneric;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.CreationParams;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.FilterByxPathThread;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.HeaderRef;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.KeepTopThreadGeneric;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementType;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementWSEPR;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultSetRef;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.TransformByXSLTThread;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSConstants;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSFileHelper;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSXMLHelper;
import org.gcube.common.searchservice.searchlibrary.resultset.security.HeadMnemonic;
import org.gcube.common.searchservice.searchlibrary.resultset.security.Mnemonic;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ResultSet {
    private static Logger log = Logger.getLogger(ResultSet.class);
    private ResultSetRef ref = null;

    public ResultSet(CreationParams params) throws Exception {
        try {
            this.ref = new ResultSetRef();
            String head = RSFileHelper.generateName((short)1, null);
            String header = RSFileHelper.generateName((short)1, null);
            String encriptedKey = null;
            String strpkey = null;
            if (params.getPKey() != null) {
                this.ref.setHmnemonic(new HeadMnemonic());
                this.ref.getHmnemonic().EnableEncryption(params.getPKey());
                strpkey = new BASE64Encoder().encode(params.getPKey().getEncoded());
                SecretKey enckey = Mnemonic.genKey();
                this.ref.setMnemonic(new Mnemonic(enckey));
                encriptedKey = this.ref.getHmnemonic().Encrypt(enckey.getEncoded());
            }
            RSXMLHelper.createHead(head, header, params.properties.toArray(new String[params.properties.size()]), params.isDataflow(), params.getAccessReads(), params.isForward(), params.getExpire_date(), strpkey, encriptedKey, params.getAll_properties());
            this.ref.setHead(head);
            this.ref.setCurrentHeader(new HeaderRef(header, head));
            this.ref.setCurrentHeaderName(header);
            this.ref.setDataFlow(params.isDataflow());
            this.ref.setAccess(params.getAccessReads());
            this.ref.setExpire_date(params.getExpire_date());
        }
        catch (Exception e) {
            log.error((Object)"Could not create head part. Throwing Exception", (Throwable)e);
            throw new Exception("Could not create head part");
        }
    }

    public ResultSet(String[] properties, boolean dataFlow) throws Exception {
        try {
            this.ref = new ResultSetRef();
            String head = RSFileHelper.generateName((short)1, null);
            String header = RSFileHelper.generateName((short)1, null);
            RSXMLHelper.createHead(head, header, properties, dataFlow);
            this.ref.setHead(head);
            this.ref.setCurrentHeader(new HeaderRef(header, head));
            this.ref.setCurrentHeaderName(header);
            this.ref.setDataFlow(dataFlow);
        }
        catch (Exception e) {
            log.error((Object)"Could not create head part. Throwing Exception", (Throwable)e);
            throw new Exception("Could not create head part");
        }
    }

    public ResultSet(String properties, boolean dataFlow) throws Exception {
        try {
            this.ref = new ResultSetRef();
            String head = RSFileHelper.generateName((short)1, null);
            String header = RSFileHelper.generateName((short)1, null);
            RSXMLHelper.createHead(head, header, properties, dataFlow);
            this.ref.setHead(head);
            this.ref.setCurrentHeader(new HeaderRef(header, head));
            this.ref.setCurrentHeaderName(header);
            this.ref.setDataFlow(dataFlow);
        }
        catch (Exception e) {
            log.error((Object)"Could not create head part. Throwing Exception", (Throwable)e);
            throw new Exception("Could not create head part");
        }
    }

    public ResultSet(String filename) throws Exception {
        this.ref = new ResultSetRef();
        if (!new File(filename).exists()) {
            log.error((Object)("Head file " + filename + " does not exist. Throwsin Exception"));
            throw new Exception("Head file " + filename + " does not exist");
        }
        this.ref.setHead(filename);
        this.ref.setDataFlow(RSXMLHelper.getDataFlow(RSXMLHelper.getDocument(this.ref.getHead())));
        String pk = null;
        try {
            pk = RSXMLHelper.getPublicKey(RSXMLHelper.getDocument(this.ref.getHead()));
        }
        catch (Exception x) {
            log.info((Object)"Read of security properties failed.");
        }
        if (pk != null) {
            throw new Exception("Resultset is security enabled");
        }
        try {
            this.ref.setAccess(this.decAccess());
        }
        catch (Exception e) {
            log.debug((Object)"Access counter decrease failed.");
        }
        try {
            this.ref.setForward(RSXMLHelper.getForward(RSXMLHelper.getDocument(this.ref.getHead())));
        }
        catch (Exception e) {
            log.debug((Object)"Read of Forward property failed.");
        }
        try {
            this.ref.setExpire_date(RSXMLHelper.getExpireDate(RSXMLHelper.getDocument(this.ref.getHead())));
        }
        catch (Exception e) {
            log.debug((Object)"Read of expire date property failed.");
        }
        if (this.ref.getAccess() == 0) {
            log.info((Object)"Access leasing exeeced.");
            throw new Exception("Access leasing exeeced.");
        }
        log.info((Object)(this.ref.getExpire_date().getTime() + " ?? " + Calendar.getInstance().getTimeInMillis()));
        if (this.ref.getExpire_date().getTime() != 0L && this.ref.getExpire_date().getTime() < Calendar.getInstance().getTimeInMillis()) {
            log.info((Object)"Time leasing exeeced.");
            throw new Exception("Time leasing exeeced.");
        }
    }

    public ResultSet(String filename, int noDecrypt) throws Exception {
        this.ref = new ResultSetRef();
        if (!new File(filename).exists()) {
            log.error((Object)("Head file " + filename + " does not exist. Throwsin Exception"));
            throw new Exception("Head file " + filename + " does not exist");
        }
        this.ref.setHead(filename);
        this.ref.setDataFlow(RSXMLHelper.getDataFlow(RSXMLHelper.getDocument(this.ref.getHead())));
        String pk = null;
        try {
            this.ref.setHmnemonic(new HeadMnemonic());
            pk = RSXMLHelper.getPublicKey(RSXMLHelper.getDocument(this.ref.getHead()));
            this.ref.setHmnemonic(new HeadMnemonic());
            SecretKey enckey = Mnemonic.genKey();
            this.ref.setMnemonic(new Mnemonic(enckey));
        }
        catch (Exception x) {
            log.info((Object)"Read of security properties failed.");
            throw new Exception("Resultset is not security enabled", x);
        }
        if (pk != null && noDecrypt != 1) {
            throw new Exception("Resultset is security enabled");
        }
        try {
            this.ref.setAccess(this.decAccess());
        }
        catch (Exception e) {
            log.debug((Object)"Access counter decrease failed.");
        }
        try {
            this.ref.setForward(RSXMLHelper.getForward(RSXMLHelper.getDocument(this.ref.getHead())));
        }
        catch (Exception e) {
            log.debug((Object)"Read of Forward property failed.");
        }
        try {
            this.ref.setExpire_date(RSXMLHelper.getExpireDate(RSXMLHelper.getDocument(this.ref.getHead())));
        }
        catch (Exception e) {
            log.debug((Object)"Read of expire date property failed.");
        }
        if (this.ref.getAccess() == 0) {
            log.debug((Object)"Access leasing exeeced.");
            throw new Exception("Access leasing exeeced.");
        }
        if (this.ref.getExpire_date().getTime() != 0L && this.ref.getExpire_date().getTime() < Calendar.getInstance().getTimeInMillis()) {
            log.debug((Object)"Time leasing exeeced.");
            throw new Exception("Time leasing exeeced.");
        }
    }

    public ResultSet(String filename, PrivateKey privkey) throws Exception {
        this.ref = new ResultSetRef();
        if (!new File(filename).exists()) {
            log.error((Object)("Head file " + filename + " does not exist. Throwsin Exception"));
            throw new Exception("Head file " + filename + " does not exist");
        }
        this.ref.setHead(filename);
        this.ref.setDataFlow(RSXMLHelper.getDataFlow(RSXMLHelper.getDocument(this.ref.getHead())));
        String pk = null;
        try {
            pk = RSXMLHelper.getPublicKey(RSXMLHelper.getDocument(this.ref.getHead()));
            this.ref.setHmnemonic(new HeadMnemonic());
            this.ref.getHmnemonic().EnableDecryption(privkey);
            this.ref.getHmnemonic().EnableEncryption(new BASE64Decoder().decodeBuffer(pk));
            String enckey = RSXMLHelper.getEncKey(RSXMLHelper.getDocument(this.ref.getHead()));
            this.ref.setMnemonic(new Mnemonic(this.ref.getHmnemonic().Decrypt(enckey)));
        }
        catch (Exception x) {
            log.info((Object)"Read of security properties failed.");
            throw new Exception("Resultset is not security enabled", x);
        }
        if (pk == null) {
            throw new Exception("Resultset is not security enabled");
        }
        try {
            this.ref.setAccess(this.decAccess());
        }
        catch (Exception e) {
            log.debug((Object)"Access counter decrease failed.");
        }
        try {
            this.ref.setForward(RSXMLHelper.getForward(RSXMLHelper.getDocument(this.ref.getHead())));
        }
        catch (Exception e) {
            log.debug((Object)"Read of Forward property failed.");
        }
        try {
            this.ref.setExpire_date(RSXMLHelper.getExpireDate(RSXMLHelper.getDocument(this.ref.getHead())));
        }
        catch (Exception e) {
            log.debug((Object)"Read of expire date property failed.");
        }
        if (this.ref.getAccess() == 0) {
            log.debug((Object)"Access leasing exeeced.");
            throw new Exception("Access leasing exeeced.");
        }
        if (this.ref.getExpire_date().getTime() != 0L && this.ref.getExpire_date().getTime() < Calendar.getInstance().getTimeInMillis()) {
            log.debug((Object)"Time leasing exeeced.");
            throw new Exception("Time leasing exeeced.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWSEPR(String epr) throws Exception {
        try {
            Object object = RSConstants.lockHead;
            synchronized (object) {
                RSXMLHelper.persistDocument(RSXMLHelper.addCustomProperty(RSXMLHelper.getDocument(this.ref.getHead()), new PropertyElementWSEPR(epr)), this.ref.getHead());
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not add WSEPR to file " + this.ref.getHead() + " Throwing Exception"), (Throwable)e);
            throw new Exception("Could not add WSEPR to file " + this.ref.getHead());
        }
    }

    public String getHeadName() throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        return this.ref.getHead();
    }

    public void clear() throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        this.ref.clear();
    }

    public ResultSetRef getRSRef() {
        return this.ref;
    }

    public boolean addResults(String[] results) throws Exception {
        log.trace((Object)"addResults called");
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (results == null || results.length == 0) {
            return true;
        }
        boolean ret = true;
        for (int i = 0; i < results.length; ++i) {
            if (results[i] == null || this.ref.addResult(results[i])) continue;
            ret = false;
        }
        return ret;
    }

    public boolean addText(String[] results) throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (results == null || results.length == 0) {
            return true;
        }
        for (int i = 0; i < results.length; ++i) {
            if (results[i] == null) continue;
            this.ref.addText(results[i]);
        }
        return true;
    }

    public RSConstants.CONTROLFLOW more(long time) throws Exception {
        try {
            if (!this.ref.isDataFlow()) {
                return RSConstants.CONTROLFLOW.MORE;
            }
            return RSFileHelper.waitOnFlowNotification(this.ref.getHead(), time);
        }
        catch (Exception e) {
            log.error((Object)"Could not check for more results request. Throwing exception", (Throwable)e);
            throw new Exception("Could not check for more results request");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewPart() throws Exception {
        log.trace((Object)"startNewPart called");
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        try {
            String header = RSFileHelper.generateName((short)1, null);
            this.ref.updateHeaderNext(header);
            String currentHeaderPart = this.ref.getCurrentHeaderName();
            String currentContentPart = RSFileHelper.headerToContent(currentHeaderPart);
            if (!this.ref.inWrap() || this.ref.getInWrap() == null) {
                RSFileHelper.persistContent(currentContentPart, this.ref.getResults(), -1, this.ref.getMnemonic());
            } else {
                RSFileHelper.persistContent(currentContentPart, this.ref.getInWrap(), this.ref.getMnemonic());
                this.ref.resetInWrap();
            }
            RSFileHelper.persistHeader(this.ref.getCurrentHeader());
            this.ref.clear();
            this.ref.setCurrentHeader(new HeaderRef(header, currentHeaderPart));
            this.ref.setCurrentHeaderName(header);
            Object object = RSConstants.sleepOnIt;
            synchronized (object) {
                RSConstants.sleepOnIt.notifyAll();
                if (this.ref.isDataFlow()) {
                    RSFileHelper.notifyOnFlowCreation(this.ref.getHead());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not create a new part. Throwing Exception", (Throwable)e);
            throw new Exception("Could not create a new part");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAuthoring() throws Exception {
        log.trace((Object)"endAuthoring called");
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        try {
            this.ref.updateHeaderNext("no");
            String currentHeaderPart = this.ref.getCurrentHeaderName();
            String currentContentPart = RSFileHelper.headerToContent(currentHeaderPart);
            if (!this.ref.inWrap() || this.ref.getInWrap() == null) {
                RSFileHelper.persistContent(currentContentPart, this.ref.getResults(), -1, this.ref.getMnemonic());
            } else {
                RSFileHelper.persistContent(currentContentPart, this.ref.getInWrap(), this.ref.getMnemonic());
                this.ref.resetInWrap();
            }
            RSFileHelper.persistHeader(this.ref.getCurrentHeader());
            String headname = this.ref.getHead();
            this.ref.clear();
            this.ref.setHead(headname);
            Object object = RSConstants.sleepOnIt;
            synchronized (object) {
                RSConstants.sleepOnIt.notifyAll();
                if (this.ref.isDataFlow()) {
                    RSFileHelper.notifyOnFlowCreation(this.ref.getHead());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not end authoring. Throwing Exception", (Throwable)e);
            throw new Exception("Could not end authoring");
        }
    }

    public void overrideProperties(PropertyElementBase[] properties) throws Exception {
        try {
            String[] props = new String[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                props[i] = properties[i].RS_toXML();
            }
            RSXMLHelper.updateProperties(this.ref.getHead(), props);
        }
        catch (Exception e) {
            log.error((Object)"could not override and update properties. throwing exception", (Throwable)e);
            throw new Exception("could not override and update properties");
        }
    }

    public void overrideProperties(String properties) throws Exception {
        try {
            RSXMLHelper.updateProperties(this.ref.getHead(), properties);
        }
        catch (Exception e) {
            log.error((Object)"could not override and update properties. throwing exception", (Throwable)e);
            throw new Exception("could not override and update properties");
        }
    }

    public void wrapFile(String filename) throws Exception {
        log.trace((Object)("wrapFile called with " + filename));
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (!new File(filename).exists()) {
            log.error((Object)("Head file " + filename + " does not exist. Throwsin Exception"));
            throw new Exception("Head file " + filename + " does not exist");
        }
        this.ref.setInWrap(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getProperties(String type) throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        Vector<String> ret = null;
        if (this.ref.getHead() == null) {
            log.error((Object)"Head File name is null. Throwing Exception");
            throw new Exception("Head File name is null");
        }
        try {
            Object object = RSConstants.lockHead;
            synchronized (object) {
                ret = RSXMLHelper.getProperties(RSXMLHelper.getDocument(this.ref.getHead()), type);
            }
            if (ret == null || ret.size() == 0) {
                return new String[0];
            }
            String[] props = new String[ret.size()];
            for (int i = 0; i < ret.size(); ++i) {
                props[i] = ret.get(i);
            }
            return props;
        }
        catch (Exception e) {
            log.error((Object)"could not retrieve properties. Throwing Exception", (Throwable)e);
            throw new Exception("could not retrieve properties");
        }
    }

    public boolean nextAvailable() throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        try {
            String next = null;
            next = this.ref.getCurrentHeaderName() == null ? RSXMLHelper.getLink(RSXMLHelper.getDocument(this.ref.getHead()), "next") : (this.ref.getCurrentHeader() != null ? this.ref.getCurrentHeader().getNext() : RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()).getNext());
            if (next.equalsIgnoreCase("no")) {
                return true;
            }
            return RSFileHelper.isReady(next);
        }
        catch (Exception e) {
            log.error((Object)"Could not check if next part is available. Throwing Exception", (Throwable)e);
            throw new Exception("Could not check if next part is available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNextPart(int waitMax) throws Exception {
        log.debug((Object)"getNextPart called");
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        try {
            int maxWaitingTime = 300000;
            if (waitMax >= 0) {
                maxWaitingTime = waitMax;
            }
            String next = null;
            if (this.ref.getCurrentHeaderName() == null) {
                next = RSXMLHelper.getLink(RSXMLHelper.getDocument(this.ref.getHead()), "next");
            } else if (this.ref.getCurrentHeader() != null) {
                next = this.ref.getCurrentHeader().getNext();
            } else {
                if (!RSFileHelper.waitForIt(this.ref.getCurrentHeaderName(), maxWaitingTime, this.ref.isDataFlow(), this.ref.getHead())) {
                    log.error((Object)"Maximum waiting ammount of time reached. Throwing Exception");
                    throw new Exception("Maximum waiting ammount of time reached");
                }
                next = RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()).getNext();
            }
            if (next.equalsIgnoreCase("no")) {
                this.ref.clearResults();
                return false;
            }
            if (RSFileHelper.isReady(next)) {
                this.ref.setCurrentHeaderName(next);
                this.ref.setCurrentHeader(RSFileHelper.populateHeader(next));
                if (this.ref.getCurrentHeader().getLocalName() == null) {
                    log.error((Object)"THE NEXT1 IS NULL");
                }
                RSFileHelper.touchHeader(next);
                this.ref.clearResults();
                if (this.getAccessLeasing() == 0 && this.isForward()) {
                    this.removePreviousPart();
                }
                return true;
            }
            long startTime = Calendar.getInstance().getTimeInMillis();
            do {
                if (Calendar.getInstance().getTimeInMillis() - startTime >= (long)maxWaitingTime) {
                    log.error((Object)"Maximum waiting ammount of time reached. Throwing Exception");
                    throw new Exception("Maximum waiting ammount of time reached");
                }
                try {
                    if (this.ref.isDataFlow()) {
                        RSFileHelper.requestFlowCreation(this.ref.getHead());
                    }
                    Object object = RSConstants.sleepOnIt;
                    synchronized (object) {
                        RSConstants.sleepOnIt.wait(250L);
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
            } while (!RSFileHelper.isReady(next));
            this.ref.setCurrentHeaderName(next);
            this.ref.setCurrentHeader(RSFileHelper.populateHeader(next));
            if (this.ref.getCurrentHeader().getLocalName() == null) {
                log.error((Object)"THE NEXT2 IS NULL");
            }
            RSFileHelper.touchHeader(next);
            this.ref.clearResults();
            if (this.getAccessLeasing() == 0 && this.isForward()) {
                this.removePreviousPart();
            }
            return true;
        }
        catch (Exception e) {
            this.ref.clearResults();
            log.error((Object)"Could not move to next part. Throwing Exception", (Throwable)e);
            throw new Exception("Could not move to next part");
        }
    }

    public boolean getFirstPart() throws Exception {
        log.debug((Object)"getFirstPart called");
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        this.ref.setCurrentHeader(null);
        this.ref.setCurrentHeaderName(null);
        this.ref.clearResults();
        return this.getNextPart(-1);
    }

    public boolean getPreviousPart() throws Exception {
        if (this.isForward()) {
            log.error((Object)"This is a forward only RS.Throwing Exception");
            throw new Exception("This is a forward only RS.");
        }
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        try {
            String prev = null;
            if (this.ref.getCurrentHeaderName() == null) {
                return false;
            }
            prev = this.ref.getCurrentHeader() == null ? RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()).getPrev() : this.ref.getCurrentHeader().getPrev();
            if (prev.compareTo(this.ref.getHead()) == 0) {
                return false;
            }
            if (RSFileHelper.isReady(prev)) {
                this.ref.setCurrentHeaderName(prev);
                this.ref.setCurrentHeader(RSFileHelper.populateHeader(prev));
                this.ref.clearResults();
                return true;
            }
            log.error((Object)"Could not move to previous part. This shouldn't happen. Throwing Exception");
            throw new Exception("Could not move to previous part");
        }
        catch (Exception e) {
            log.error((Object)"Could not move to previous part. Throwing Exception", (Throwable)e);
            throw new Exception("Could not move to previous part");
        }
    }

    public boolean removePreviousPart() throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        try {
            File tmp;
            ResultSetRef prevref = new ResultSetRef();
            String prev = null;
            if (this.ref.getCurrentHeaderName() == null) {
                return false;
            }
            prev = this.ref.getCurrentHeader() == null ? RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()).getPrev() : this.ref.getCurrentHeader().getPrev();
            if (prev.compareTo(this.ref.getHead()) == 0) {
                return false;
            }
            if (!RSFileHelper.isReady(prev)) {
                return false;
            }
            prevref.setCurrentHeaderName(prev);
            prevref.setCurrentHeader(RSFileHelper.populateHeader(prev));
            prevref.clearResults();
            ResultSetRef prevprevref = new ResultSetRef();
            String prevprev = null;
            if (prevref.getCurrentHeaderName() == null) {
                return false;
            }
            prevprev = prevref.getCurrentHeader().getPrev();
            if (prevprev.compareTo(this.ref.getHead()) == 0) {
                return false;
            }
            if (!RSFileHelper.isReady(prevprev)) {
                return false;
            }
            prevprevref.setCurrentHeaderName(prevprev);
            prevprevref.setCurrentHeader(RSFileHelper.populateHeader(prevprev));
            prevprevref.clearResults();
            prevprevref.updateHeaderNext(prevref.getCurrentHeader().getNext());
            RSFileHelper.persistHeader(prevprevref.getCurrentHeader());
            this.ref.updateHeaderPrev(prevref.getCurrentHeader().getPrev());
            RSFileHelper.persistHeader(this.ref.getCurrentHeader());
            String dir = null;
            try {
                tmp = new File(prevref.getCurrentHeaderName());
                dir = tmp.getParent();
                tmp.delete();
                log.debug((Object)("deleting file (name retrivied from metadata .rs ) " + prevref.getCurrentHeaderName()));
            }
            catch (Exception e) {
                log.error((Object)("could not delete file " + prevref.getCurrentHeaderName() + " continuing"), (Throwable)e);
            }
            try {
                tmp = new File(RSFileHelper.headerToContent(prevref.getCurrentHeaderName()));
                tmp.delete();
                log.debug((Object)("deleting file (name retrivied from metadata .hrs )" + RSFileHelper.headerToContent(prevref.getCurrentHeaderName())));
            }
            catch (Exception e) {
                log.error((Object)("could not delete content file of " + prevref.getCurrentHeaderName() + " continuing"), (Throwable)e);
            }
            try {
                log.trace((Object)"try to remove the RS directory");
                tmp = new File(dir);
                tmp.delete();
                log.trace((Object)("Directory " + dir + " removed"));
            }
            catch (Exception e) {
                log.error((Object)"could not remove directory", (Throwable)e);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Could not move to previous part. Throwing Exception", (Throwable)e);
            throw new Exception("Could not move to previous part");
        }
    }

    public boolean isFirst() throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        try {
            if (this.ref.getCurrentHeaderName() == null) {
                return true;
            }
            String prev = null;
            prev = this.ref.getCurrentHeader() == null ? RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()).getPrev() : this.ref.getCurrentHeader().getPrev();
            return prev.compareTo(this.ref.getHead()) == 0;
        }
        catch (Exception e) {
            log.error((Object)"Could not move to previous part. Throwing Exception", (Throwable)e);
            throw new Exception("Could not move to previous part");
        }
    }

    public boolean isLast() throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getCurrentHeaderName() == null) {
            return false;
        }
        String next = null;
        next = this.ref.getCurrentHeader() == null ? RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()).getNext() : this.ref.getCurrentHeader().getNext();
        return next.compareTo("no") == 0;
    }

    public int getNumberOfResults(String type) throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getCurrentHeaderName() == null) {
            this.getNextPart(-1);
        }
        if (!RSFileHelper.waitForIt(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.isDataFlow(), this.ref.getHead())) {
            log.error((Object)("Could not find payload part" + RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()) + ". Throwing Exception"));
            throw new Exception("Could not find payload part");
        }
        try {
            if (this.ref.getCurrentHeader() == null) {
                this.ref.setCurrentHeader(RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()));
            }
            if (type.equalsIgnoreCase(PropertyElementType.XML)) {
                if (this.ref.getResults().size() == 0) {
                    this.ref.setResults(RSFileHelper.populateResults(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.getMnemonic()));
                }
                return this.ref.getResults().size();
            }
            if (type.equalsIgnoreCase(PropertyElementType.TEXT)) {
                return RSFileHelper.getNumberOfResultsInTextFile(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()));
            }
            log.error((Object)("Unregognized type " + type + ". Throwing Exception"));
            throw new Exception("Unregognized type " + type);
        }
        catch (Exception e) {
            log.error((Object)"Could not get Number of results. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get Number of results");
        }
    }

    public String getCurrentContentPartPayload() throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getCurrentHeaderName() == null) {
            this.getNextPart(-1);
        }
        if (!RSFileHelper.waitForIt(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.isDataFlow(), this.ref.getHead())) {
            log.error((Object)("Could not find payload part" + RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()) + ". Throwing Exception"));
            throw new Exception("Could not find payload part");
        }
        try {
            return this.getFileContent(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()));
        }
        catch (Exception e) {
            log.error((Object)"Could not get Number of results. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get Number of results");
        }
    }

    public String getResult(int index) throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getCurrentHeaderName() == null) {
            this.getNextPart(-1);
        }
        if (!RSFileHelper.waitForIt(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.isDataFlow(), this.ref.getHead())) {
            log.error((Object)("Could not find payload part" + RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()) + ". Throwing Exception"));
            throw new Exception("Could not find payload part");
        }
        try {
            if (this.ref.getCurrentHeader() == null) {
                this.ref.setCurrentHeader(RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()));
            }
            if (this.ref.getResults().size() == 0) {
                this.ref.setResults(RSFileHelper.populateResults(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.getMnemonic()));
            }
            if (index >= this.ref.getResults().size() || index < 0) {
                log.warn((Object)"provided index excedes available records. In case of a BLOB rs this is not alarming :-).Throwing Exception");
                throw new Exception("provided index excedes available records. In case of a BLOB rs this is not alarming :-)");
            }
            return this.ref.getResults().get(index);
        }
        catch (Exception e) {
            log.warn((Object)("Could not retrieve result with index" + index + ". In case of a BLOB rs this is not alarming :-). Throwing Exception"));
            throw new Exception("Could not retrieve result with index" + index + ". In case of a BLOB rs this is not alarming :-)");
        }
    }

    public String[] getResults() throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getCurrentHeaderName() == null) {
            this.getNextPart(-1);
        }
        if (!RSFileHelper.waitForIt(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.isDataFlow(), this.ref.getHead())) {
            log.error((Object)("Could not find payload part" + RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()) + ". Throwing Exception"));
            throw new Exception("Could not find payload part");
        }
        try {
            if (this.ref.getCurrentHeader() == null) {
                this.ref.setCurrentHeader(RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()));
            }
            if (this.ref.getResults().size() == 0) {
                this.ref.setResults(RSFileHelper.populateResults(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.getMnemonic()));
            }
            return this.ref.getResults().toArray(new String[0]);
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve results. Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve results");
        }
    }

    public String[] getResults(int from, int to) throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getCurrentHeaderName() == null) {
            this.getNextPart(-1);
        }
        if (!RSFileHelper.waitForIt(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.isDataFlow(), this.ref.getHead())) {
            log.error((Object)("Could not find payload part" + RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()) + ". Throwing Exception"));
            throw new Exception("Could not find payload part");
        }
        try {
            if (this.ref.getCurrentHeader() == null) {
                this.ref.setCurrentHeader(RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()));
            }
            if (this.ref.getResults().size() == 0) {
                this.ref.setResults(RSFileHelper.populateResults(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.getMnemonic()));
            }
            if (from < 0 || to > this.ref.getResults().size() || to < from || to == from) {
                log.error((Object)"Not valid from-to arguments. Throwing Exception");
                throw new Exception("Not valid from-to arguments");
            }
            return this.ref.getResults().subList(from, to).toArray(new String[0]);
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve results. Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve results");
        }
    }

    public String getHostIP() throws Exception {
        try {
            InetAddress localaddr = InetAddress.getLocalHost();
            return localaddr.getHostAddress();
        }
        catch (Exception e) {
            log.error((Object)"Could not get Host IP. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get Host IP");
        }
    }

    public String getHostName() throws Exception {
        try {
            InetAddress localaddr = InetAddress.getLocalHost();
            return localaddr.getHostName();
        }
        catch (Exception e) {
            log.error((Object)"Could not get Host name. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get Host name");
        }
    }

    public String[] splitEncoded() throws Exception {
        log.trace((Object)"splitEncoded called");
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getCurrentHeaderName() == null) {
            this.getNextPart(-1);
        }
        if (!RSFileHelper.waitForIt(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.isDataFlow(), this.ref.getHead())) {
            log.error((Object)("Could not find payload part" + RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()) + ". Throwing Exception"));
            throw new Exception("Could not find payload part");
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            if (this.ref.getCurrentHeader() == null) {
                this.ref.setCurrentHeader(RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()));
            }
            String plain = RSFileHelper.generateName((short)2, null);
            DataInputStream instring = RSFileHelper.getBinaryContent(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.getMnemonic());
            out = new FileOutputStream(new File(plain));
            byte[] buf = new byte[4096];
            while ((len = instring.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            instring.close();
            out.close();
            BASE64Encoder encoder = new BASE64Encoder();
            in = new FileInputStream(new File(plain));
            String encoded = RSFileHelper.generateName((short)2, null);
            out = new FileOutputStream(new File(encoded));
            encoder.encode((InputStream)in, (OutputStream)out);
            in.close();
            in = null;
            out.close();
            out = null;
            return RSFileHelper.splitFile(encoded);
        }
        catch (Exception e) {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            log.error((Object)"Could not retrieve results. Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve results");
        }
    }

    public String[] splitClear() throws Exception {
        log.trace((Object)"splitClear called");
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getCurrentHeaderName() == null) {
            this.getNextPart(-1);
        }
        if (!RSFileHelper.waitForIt(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.isDataFlow(), this.ref.getHead())) {
            log.error((Object)("Could not find payload part" + RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()) + ". Throwing Exception"));
            throw new Exception("Could not find payload part");
        }
        try {
            if (this.ref.getCurrentHeader() == null) {
                this.ref.setCurrentHeader(RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()));
            }
            if (this.ref.getMnemonic() != null) {
                int len;
                String plain = RSFileHelper.generateName((short)2, null);
                String content = RSFileHelper.getContent(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.getMnemonic());
                FileOutputStream out = new FileOutputStream(new File(plain));
                ByteArrayInputStream instring = new ByteArrayInputStream(content.getBytes());
                byte[] buf = new byte[4096];
                while ((len = instring.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                ((InputStream)instring).close();
                out.close();
                return RSFileHelper.splitFile(plain);
            }
            return RSFileHelper.splitFile(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()));
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve results. Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve results");
        }
    }

    public String getFileContent(String filename) throws Exception {
        try {
            return RSFileHelper.getContent(filename, this.ref.getMnemonic());
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve file content " + filename), (Throwable)e);
            throw new Exception("Could not retrieve file content " + filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieveCustomProperties() throws Exception {
        if (this.ref == null || this.ref.getHead() == null) {
            log.error((Object)"Incorrect initialization.Throwing Exception");
            throw new Exception("Incorrect initialization");
        }
        if (!RSFileHelper.waitForIt(this.ref.getHead(), this.ref.isDataFlow(), this.ref.getHead())) {
            log.error((Object)("Could not find head part " + this.ref.getHead() + ". Throwing Exception"));
            throw new Exception("Could not find head part " + this.ref.getHead());
        }
        try {
            String props = null;
            Object object = RSConstants.lockHead;
            synchronized (object) {
                props = RSXMLHelper.retrieveCustomProperties(RSXMLHelper.getDocument(this.ref.getHead()));
            }
            return props;
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve Custom Properties . Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve Custom Properties");
        }
    }

    public String cloneRS() throws Exception {
        try {
            CreationParams cp = new CreationParams();
            cp.setAccessReads(this.getAccessLeasing());
            cp.setDataflow(false);
            cp.setExpire_date(this.getTimeLeasing());
            cp.setForward(this.ref.isForward());
            if (this.ref.getHmnemonic() != null) {
                cp.setPKey(this.ref.getHmnemonic().getPublickey());
            }
            cp.setAll_properties(this.retrieveCustomProperties());
            ResultSet rs = new ResultSet(cp);
            ResultSet rsRead = null;
            rsRead = this.ref.getHmnemonic() != null ? (this.ref.getHmnemonic().getPrivatekey() != null ? new ResultSet(this.ref.getHead(), this.ref.getHmnemonic().getPrivatekey()) : new ResultSet(this.ref.getHead())) : new ResultSet(this.ref.getHead());
            String rsHead = rs.getHeadName();
            CloneThreadGeneric worker = new CloneThreadGeneric(rs, rsRead);
            worker.start();
            return rsHead;
        }
        catch (Exception e) {
            log.error((Object)"Could not get perform cloning in Service Side. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get perform cloning in Service Side");
        }
    }

    public String keepTop(int count, short type) throws Exception {
        try {
            String properties = this.retrieveCustomProperties();
            ResultSet rs = new ResultSet(properties, false);
            ResultSet rsRead = new ResultSet(this.ref.getHead());
            String rsHead = rs.getHeadName();
            KeepTopThreadGeneric worker = new KeepTopThreadGeneric(rs, rsRead, count, type);
            worker.start();
            return rsHead;
        }
        catch (Exception e) {
            log.error((Object)"Could not get perform keepTop in Service Side. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get perform keepTop in Service Side");
        }
    }

    public String keepTop(String[] properties, int count, short type) throws Exception {
        try {
            ResultSet rs = new ResultSet(properties, false);
            ResultSet rsRead = new ResultSet(this.ref.getHead());
            String rsHead = rs.getHeadName();
            KeepTopThreadGeneric worker = new KeepTopThreadGeneric(rs, rsRead, count, type);
            worker.start();
            return rsHead;
        }
        catch (Exception e) {
            log.error((Object)"Could not get perform keepTop in Service Side. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get perform keepTop in Service Side");
        }
    }

    public String getCurrentContentPartName() throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getCurrentHeaderName() == null) {
            this.getNextPart(-1);
        }
        if (!RSFileHelper.waitForIt(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.isDataFlow(), this.ref.getHead())) {
            log.error((Object)("Could not find payload part" + RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()) + ". Throwing Exception"));
            throw new Exception("Could not find payload part");
        }
        return RSFileHelper.headerToContent(this.ref.getCurrentHeaderName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeQueryOnHead(String xPath) throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getHead() == null) {
            log.error((Object)"Head File name is null. Throwing Exception");
            throw new Exception("Head File name is null");
        }
        try {
            String ret = null;
            Object object = RSConstants.lockHead;
            synchronized (object) {
                ret = RSXMLHelper.executeQueryOnDocument(RSXMLHelper.getDocument(this.ref.getHead()), xPath);
            }
            return ret;
        }
        catch (Exception e) {
            log.error((Object)"could not execute query on head. Throwing Exception", (Throwable)e);
            throw new Exception("could not execute query on head");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeQueryOnDocument(String xPath) throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getCurrentHeaderName() == null) {
            this.getNextPart(-1);
        }
        if (!RSFileHelper.waitForIt(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.isDataFlow(), this.ref.getHead())) {
            log.error((Object)("Could not find payload part" + RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()) + ". Throwing Exception"));
            throw new Exception("Could not find payload part");
        }
        try {
            if (this.ref.getCurrentHeader() == null) {
                this.ref.setCurrentHeader(RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()));
            }
            String ret = null;
            Object object = RSConstants.lockHead;
            synchronized (object) {
                ret = RSXMLHelper.executeQueryOnDocument(RSXMLHelper.getDocument(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName())), xPath);
            }
            return ret;
        }
        catch (Exception e) {
            log.error((Object)"could not execute query on head. Throwing Exception", (Throwable)e);
            throw new Exception("could not execute query on head");
        }
    }

    public String[] executeQueryOnResults(String xPath) throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getCurrentHeaderName() == null) {
            this.getNextPart(-1);
        }
        if (!RSFileHelper.waitForIt(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.isDataFlow(), this.ref.getHead())) {
            log.error((Object)("Could not find payload part" + RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()) + ". Throwing Exception"));
            throw new Exception("Could not find payload part");
        }
        try {
            if (this.ref.getCurrentHeader() == null) {
                this.ref.setCurrentHeader(RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()));
            }
            if (this.ref.getResults().size() == 0) {
                this.ref.setResults(RSFileHelper.populateResults(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.getMnemonic()));
            }
            Vector<String> res = new Vector<String>();
            for (int i = 0; i < this.ref.getResults().size(); ++i) {
                try {
                    if (!RSXMLHelper.executeQueryOnResults(this.ref.getResults().get(i), xPath)) continue;
                    res.add(this.ref.getResults().get(i));
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"Caught Exception while executing Query on result. Continuing", (Throwable)e);
                }
            }
            return res.toArray(new String[0]);
        }
        catch (Exception e) {
            log.error((Object)"Could not execute query. Throwing Exception", (Throwable)e);
            throw new Exception("Could not execute query");
        }
    }

    public String filterRS(String xPath) throws Exception {
        try {
            String properties = this.retrieveCustomProperties();
            ResultSet rs = new ResultSet(properties, false);
            ResultSet rsRead = new ResultSet(this.ref.getHead());
            String rsHead = rs.getHeadName();
            FilterByxPathThread worker = new FilterByxPathThread(rs, rsRead, xPath);
            worker.start();
            return rsHead;
        }
        catch (Exception e) {
            log.error((Object)"Could not get perform filter By xPath in Service Side. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get perform filter By xPath in Service Side");
        }
    }

    public String filterRS(String xPath, String[] properties) throws Exception {
        try {
            ResultSet rs = new ResultSet(properties, false);
            ResultSet rsRead = new ResultSet(this.ref.getHead());
            String rsHead = rs.getHeadName();
            FilterByxPathThread worker = new FilterByxPathThread(rs, rsRead, xPath);
            worker.start();
            return rsHead;
        }
        catch (Exception e) {
            log.error((Object)"Could not get perform filter By xPath in Service Side. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get perform filter By xPath in Service Side");
        }
    }

    public String transformByXSLT(String xslt) throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getCurrentHeaderName() == null) {
            this.getNextPart(-1);
        }
        if (!RSFileHelper.waitForIt(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.isDataFlow(), this.ref.getHead())) {
            log.error((Object)("Could not find payload part" + RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()) + ". Throwing Exception"));
            throw new Exception("Could not find payload part");
        }
        try {
            if (this.ref.getCurrentHeader() == null) {
                this.ref.setCurrentHeader(RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()));
            }
            String transformFile = RSFileHelper.generateName((short)0, null);
            RSXMLHelper.transform(xslt, RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), transformFile);
            String content = RSFileHelper.getContent(transformFile, this.ref.getMnemonic());
            new File(transformFile).delete();
            return content;
        }
        catch (Exception e) {
            log.error((Object)"Could not execute query. Throwing Exception", (Throwable)e);
            throw new Exception("Could not execute query");
        }
    }

    public String transformByXSLTAndPersist(String xslt) throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getCurrentHeaderName() == null) {
            this.getNextPart(-1);
        }
        if (!RSFileHelper.waitForIt(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.isDataFlow(), this.ref.getHead())) {
            log.error((Object)("Could not find payload part" + RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()) + ". Throwing Exception"));
            throw new Exception("Could not find payload part");
        }
        try {
            if (this.ref.getCurrentHeader() == null) {
                this.ref.setCurrentHeader(RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()));
            }
            String transformFile = RSFileHelper.generateName((short)0, null);
            RSXMLHelper.transform(xslt, RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), transformFile);
            return transformFile;
        }
        catch (Exception e) {
            log.error((Object)"Could not execute query. Throwing Exception", (Throwable)e);
            throw new Exception("Could not execute query");
        }
    }

    public String transformByXSLTAndPersist(Templates xslt) throws Exception {
        if (this.ref == null) {
            log.error((Object)"Incorrect initialization. RSRef is null.Throwing Exception");
            throw new Exception("Incorrect initialization. RSRef is null");
        }
        if (this.ref.getCurrentHeaderName() == null) {
            this.getNextPart(-1);
        }
        if (!RSFileHelper.waitForIt(RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), this.ref.isDataFlow(), this.ref.getHead())) {
            log.error((Object)("Could not find payload part" + RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()) + ". Throwing Exception"));
            throw new Exception("Could not find payload part");
        }
        try {
            if (this.ref.getCurrentHeader() == null) {
                this.ref.setCurrentHeader(RSFileHelper.populateHeader(this.ref.getCurrentHeaderName()));
            }
            String transformFile = RSFileHelper.generateName((short)0, null);
            RSXMLHelper.transform(xslt, RSFileHelper.headerToContent(this.ref.getCurrentHeaderName()), transformFile);
            return transformFile;
        }
        catch (Exception e) {
            log.error((Object)"Could not execute query. Throwing Exception", (Throwable)e);
            throw new Exception("Could not execute query");
        }
    }

    public String transformRS(String transformation) throws Exception {
        try {
            String properties = this.retrieveCustomProperties();
            ResultSet rs = new ResultSet(properties, false);
            ResultSet rsRead = new ResultSet(this.ref.getHead());
            String rsHead = rs.getHeadName();
            TransformByXSLTThread worker = new TransformByXSLTThread(rs, rsRead, transformation);
            worker.start();
            return rsHead;
        }
        catch (Exception e) {
            log.error((Object)"Could not get perform transformation By XSLT in Service Side. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get perform transformation By XSLT in Service Side");
        }
    }

    public String transformRS(String transformation, String[] properties) throws Exception {
        try {
            ResultSet rs = new ResultSet(properties, false);
            ResultSet rsRead = new ResultSet(this.ref.getHead());
            String rsHead = rs.getHeadName();
            TransformByXSLTThread worker = new TransformByXSLTThread(rs, rsRead, transformation);
            worker.start();
            return rsHead;
        }
        catch (Exception e) {
            log.error((Object)"Could not get perform transformation By XSLT in Service Side. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get perform transformation By XSLT in Service Side");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decAccess() throws Exception {
        try {
            Object object = RSConstants.lockHead;
            synchronized (object) {
                int access = RSXMLHelper.getAccess(RSXMLHelper.getDocument(this.ref.getHead()));
                if (access == 0) {
                    return access;
                }
                RSXMLHelper.persistDocument(RSXMLHelper.updateAccessCounter(RSXMLHelper.getDocument(this.ref.getHead()), --access), this.ref.getHead());
                return access;
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not decrease forward counter " + this.ref.getHead() + " Throwing Exception"), (Throwable)e);
            throw new Exception("Could not decrease forward counter " + this.ref.getHead());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setAccess(int access) throws Exception {
        try {
            Object object = RSConstants.lockHead;
            synchronized (object) {
                RSXMLHelper.persistDocument(RSXMLHelper.updateAccessCounter(RSXMLHelper.getDocument(this.ref.getHead()), access), this.ref.getHead());
                return access;
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not set access counter " + this.ref.getHead() + " Throwing Exception"), (Throwable)e);
            throw new Exception("Could not set access counter " + this.ref.getHead());
        }
    }

    public void disableAccessLeasing() throws Exception {
        try {
            this.setAccess(-1);
        }
        catch (Exception e) {
            log.error((Object)("Could not disable access counter " + this.ref.getHead() + " Throwing Exception"), (Throwable)e);
            throw new Exception("Could not disable access counter " + this.ref.getHead());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extendAccessLeasing(int extend) throws Exception {
        try {
            Object object = RSConstants.lockHead;
            synchronized (object) {
                int access = RSXMLHelper.getAccess(RSXMLHelper.getDocument(this.ref.getHead()));
                RSXMLHelper.persistDocument(RSXMLHelper.updateAccessCounter(RSXMLHelper.getDocument(this.ref.getHead()), access += extend), this.ref.getHead());
                log.info((Object)("Access leasing extended to " + --access));
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not extend access counter " + this.ref.getHead() + " Throwing Exception"), (Throwable)e);
            throw new Exception("Could not extend access counter " + this.ref.getHead());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAccessLeasing() throws Exception {
        try {
            Object object = RSConstants.lockHead;
            synchronized (object) {
                int access = RSXMLHelper.getAccess(RSXMLHelper.getDocument(this.ref.getHead()));
                return --access;
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not get access counter " + this.ref.getHead() + " Throwing Exception"), (Throwable)e);
            throw new Exception("Could not get access counter " + this.ref.getHead());
        }
    }

    public boolean isForward() throws Exception {
        return RSXMLHelper.getForward(RSXMLHelper.getDocument(this.ref.getHead()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setForward(boolean f) throws Exception {
        try {
            Object object = RSConstants.lockHead;
            synchronized (object) {
                RSXMLHelper.persistDocument(RSXMLHelper.setForward(RSXMLHelper.getDocument(this.ref.getHead()), f), this.ref.getHead());
                return f;
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not set forward " + this.ref.getHead() + " Throwing Exception"), (Throwable)e);
            throw new Exception("Could not set forward " + this.ref.getHead());
        }
    }

    public Date getTimeLeasing() throws Exception {
        return RSXMLHelper.getExpireDate(RSXMLHelper.getDocument(this.ref.getHead()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extendTimeLeasing(Date extend) throws Exception {
        try {
            Object object = RSConstants.lockHead;
            synchronized (object) {
                RSXMLHelper.persistDocument(RSXMLHelper.setExpireDate(RSXMLHelper.getDocument(this.ref.getHead()), extend), this.ref.getHead());
                log.info((Object)("Time leasing extended to " + extend));
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not extend time " + this.ref.getHead() + " Throwing Exception"), (Throwable)e);
            throw new Exception("Could not extend time " + this.ref.getHead());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableTimeLeasing() throws Exception {
        try {
            Object object = RSConstants.lockHead;
            synchronized (object) {
                RSXMLHelper.persistDocument(RSXMLHelper.setExpireDate(RSXMLHelper.getDocument(this.ref.getHead()), new Date(0L)), this.ref.getHead());
                log.info((Object)"Time leasing disabled");
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not disable time " + this.ref.getHead() + " Throwing Exception"), (Throwable)e);
            throw new Exception("Could not disable time " + this.ref.getHead());
        }
    }

    public Mnemonic getMnemonic() {
        return this.ref.getMnemonic();
    }

    public HeadMnemonic getHeadMnemonic() {
        return this.ref.getHmnemonic();
    }

    public byte[] getEncKey() throws Exception {
        return RSXMLHelper.getEncKey(RSXMLHelper.getDocument(this.ref.getHead())).getBytes();
    }
}

