/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.kxml.runninginstance;

import java.util.Calendar;
import org.gcube.common.core.resources.runninginstance.DeploymentData;
import org.gcube.common.resources.kxml.KGCUBEResource;
import org.gcube.common.resources.kxml.runninginstance.KAvailablePlugins;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class KDeploymentData {
    /*
     * Enabled aggressive block sorting
     */
    public static DeploymentData load(KXmlParser parser) throws Exception {
        DeploymentData d = new DeploymentData();
        while (true) {
            switch (parser.next()) {
                case 2: {
                    Calendar cal;
                    if (parser.getName().equals("InstanceName")) {
                        d.setInstanceName(parser.nextText());
                    }
                    if (parser.getName().equals("LocalPath")) {
                        d.setLocalPath(parser.nextText());
                    }
                    if (parser.getName().equals("ActivationTime")) {
                        cal = Calendar.getInstance();
                        cal.setTime(KGCUBEResource.fromXMLDateAndTime(parser.getAttributeValue(KGCUBEResource.NS, "value")));
                        d.setActivationTime(cal);
                    }
                    if (parser.getName().equals("TerminationTime")) {
                        cal = Calendar.getInstance();
                        cal.setTime(KGCUBEResource.fromXMLDateAndTime(parser.getAttributeValue(KGCUBEResource.NS, "value")));
                        d.setTerminationTime(cal);
                    }
                    if (parser.getName().equals("Status")) {
                        String state = parser.nextText();
                        d.setState(state);
                    }
                    if (parser.getName().equals("MessageState")) {
                        d.setMessageState(parser.nextText());
                    }
                    if (!parser.getName().equals("AvailablePlugins")) break;
                    d.setPlugins(KAvailablePlugins.load(parser));
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("DeploymentData")) break;
                    return d;
                }
                case 1: {
                    throw new Exception("Parsing failed at DeploymentData");
                }
            }
        }
    }

    public static void store(DeploymentData component, KXmlSerializer serializer) throws Exception {
        if (component == null) {
            return;
        }
        serializer.startTag(KGCUBEResource.NS, "DeploymentData");
        if (component.getInstanceName() != null) {
            serializer.startTag(KGCUBEResource.NS, "InstanceName").text(component.getInstanceName()).endTag(KGCUBEResource.NS, "InstanceName");
        }
        if (component.getLocalPath() != null) {
            serializer.startTag(KGCUBEResource.NS, "LocalPath").text(component.getLocalPath()).endTag(KGCUBEResource.NS, "LocalPath");
        }
        if (component.getActivationTime() != null) {
            serializer.startTag(KGCUBEResource.NS, "ActivationTime").attribute(KGCUBEResource.NS, "value", KGCUBEResource.toXMLDateAndTime(component.getActivationTime().getTime())).endTag(KGCUBEResource.NS, "ActivationTime");
        }
        if (component.getTerminationTime() != null) {
            serializer.startTag(KGCUBEResource.NS, "TerminationTime").attribute(KGCUBEResource.NS, "value", KGCUBEResource.toXMLDateAndTime(component.getTerminationTime().getTime())).endTag(KGCUBEResource.NS, "TerminationTime");
        }
        if (component.getState() != null) {
            serializer.startTag(KGCUBEResource.NS, "Status").text(component.getState()).endTag(KGCUBEResource.NS, "Status");
        }
        if (component.getMessageState() != null) {
            serializer.startTag(KGCUBEResource.NS, "MessageState").text(component.getMessageState()).endTag(KGCUBEResource.NS, "MessageState");
        }
        if (component.getPlugins() != null) {
            KAvailablePlugins.store(component.getPlugins(), serializer);
        }
        serializer.endTag(KGCUBEResource.NS, "DeploymentData");
    }
}

