/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.gcore;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.gcube.common.resources.gcore.common.AnyWrapper;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.resources.gcore.utils.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlRootElement(name="Document")
public class ServiceInstance {
    @XmlElement(name="ID")
    private String id;
    @XmlElement(name="Source")
    private URI endpoint;
    @XmlElement(name="SourceKey")
    private String key;
    @XmlElementRef
    private Reference keyElement;
    @XmlElement(name="TerminationTime")
    private long terminationTime;
    @XmlElement(name="LastUpdateMs")
    private long lastUpdate;
    @XmlElement(name="PublicationMode")
    private String publicationMode;
    @XmlElementRef
    private Properties properties;

    public String id() {
        return this.id;
    }

    public ServiceInstance id(String id) {
        this.id = id;
        return this;
    }

    public URI endpoint() {
        return this.endpoint;
    }

    public ServiceInstance endpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String key() {
        return this.key;
    }

    public ServiceInstance key(String key) {
        this.key = key;
        return this;
    }

    public EndpointReference reference() {
        return new W3CEndpointReferenceBuilder().address(this.endpoint.toString()).referenceParameter(this.keyElement.root()).build();
    }

    public long terminationTime() {
        return this.terminationTime;
    }

    public ServiceInstance terminationTime(long terminationTime) {
        this.terminationTime = terminationTime;
        return this;
    }

    public long lastUpdate() {
        return this.lastUpdate;
    }

    public ServiceInstance lastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    public String publicationMode() {
        return this.publicationMode;
    }

    public ServiceInstance publicationMode(String publicationMode) {
        this.publicationMode = publicationMode;
        return this;
    }

    public Properties properties() {
        return this.properties;
    }

    public Properties newProperties() {
        this.properties = new Properties();
        return this.properties;
    }

    public String toString() {
        return "ServiceInstance [id=" + this.id + ", endpoint=" + this.endpoint + ", key=" + this.key + ", reference=" + this.reference() + ", terminationTime=" + this.terminationTime + ", lastUpdate=" + this.lastUpdate + ", publicationMode=" + this.publicationMode + ", properties=" + this.properties + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (int)(this.lastUpdate ^ this.lastUpdate >>> 32);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.publicationMode == null ? 0 : this.publicationMode.hashCode());
        result = 31 * result + (this.keyElement == null ? 0 : this.keyElement.hashCode());
        result = 31 * result + (int)(this.terminationTime ^ this.terminationTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceInstance other = (ServiceInstance)obj;
        if (this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.lastUpdate != other.lastUpdate) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.publicationMode == null ? other.publicationMode != null : !this.publicationMode.equals(other.publicationMode)) {
            return false;
        }
        if (this.keyElement == null ? other.keyElement != null : !this.keyElement.equals(other.keyElement)) {
            return false;
        }
        return this.terminationTime == other.terminationTime;
    }

    @XmlRootElement(name="Data")
    public static class Properties {
        public static final String PROVIDER_NS = "http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider";
        @XmlElement(name="GHN", namespace="http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider")
        private String nodeId;
        @XmlElement(name="RI", namespace="http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider")
        private String endpointId;
        @XmlElement(name="ServiceID", namespace="http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider")
        private String serviceId;
        @XmlElement(name="ServiceClass", namespace="http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider")
        private String serviceClass;
        @XmlElement(name="ServiceName", namespace="http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider")
        private String serviceName;
        @XmlElement(name="Scope", namespace="http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider")
        private List<String> scopes = new ArrayList<String>();
        private Element root;
        @XmlAnyElement
        private List<Element> customProperties;

        public String nodeId() {
            return this.nodeId;
        }

        public Properties nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public String endpointId() {
            return this.endpointId;
        }

        public Properties endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public String serviceId() {
            return this.serviceId;
        }

        public Properties serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public String serviceClass() {
            return this.serviceClass;
        }

        public Properties serviceClass(String serviceClass) {
            this.serviceClass = serviceClass;
            return this;
        }

        public String serviceName() {
            return this.serviceName;
        }

        public Properties serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Collection<String> scopes() {
            return new Group<String>(this.scopes, String.class);
        }

        public Element customProperties() {
            return this.root;
        }

        public Element newCustomProperties() {
            this.root = Utils.newDocument().getDocumentElement();
            return this.root;
        }

        void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
            if (this.customProperties != null) {
                this.newCustomProperties();
                for (Element e : this.customProperties) {
                    this.root.appendChild(this.root.getOwnerDocument().adoptNode(e));
                }
            }
            this.customProperties = null;
        }

        void beforeMarshal(Marshaller marshaller) {
            if (this.root != null) {
                this.customProperties = new ArrayList<Element>();
                NodeList list = this.root.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    Node node = list.item(i);
                    if (node.getNodeType() != 1) continue;
                    this.customProperties.add((Element)node);
                }
            }
        }

        public String toString() {
            return "Properties [nodeId=" + this.nodeId + ", endpointId=" + this.endpointId + ", serviceId=" + this.serviceId + ", serviceClass=" + this.serviceClass + ", serviceName=" + this.serviceName + ", scopes=" + this.scopes + ", customProperties=" + this.customProperties + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.customProperties == null ? 0 : ((Object)this.customProperties).hashCode());
            result = 31 * result + (this.endpointId == null ? 0 : this.endpointId.hashCode());
            result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
            result = 31 * result + (this.scopes == null ? 0 : ((Object)this.scopes).hashCode());
            result = 31 * result + (this.serviceClass == null ? 0 : this.serviceClass.hashCode());
            result = 31 * result + (this.serviceId == null ? 0 : this.serviceId.hashCode());
            result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Properties other = (Properties)obj;
            if (this.customProperties() == null ? other.customProperties() != null : !this.customProperties().isEqualNode(other.customProperties())) {
                return false;
            }
            if (this.endpointId == null ? other.endpointId != null : !this.endpointId.equals(other.endpointId)) {
                return false;
            }
            if (this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId)) {
                return false;
            }
            if (this.scopes == null ? other.scopes != null : !((Object)this.scopes).equals(other.scopes)) {
                return false;
            }
            if (this.serviceClass == null ? other.serviceClass != null : !this.serviceClass.equals(other.serviceClass)) {
                return false;
            }
            if (this.serviceId == null ? other.serviceId != null : !this.serviceId.equals(other.serviceId)) {
                return false;
            }
            return !(this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName));
        }
    }

    @XmlRootElement(name="CompleteSourceKey")
    private static class Reference
    extends AnyWrapper {
        private Reference() {
        }
    }
}

