/*
 * Decompiled with CFR 0.152.
 */
package org.globus.usage.packets;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.net.DatagramSocketFactory;
import org.globus.usage.packets.CustomByteBuffer;

public class UsageMonitorPacket {
    private static Log log = LogFactory.getLog((String)(class$org$globus$usage$packets$UsageMonitorPacket == null ? (class$org$globus$usage$packets$UsageMonitorPacket = UsageMonitorPacket.class$("org.globus.usage.packets.UsageMonitorPacket")) : class$org$globus$usage$packets$UsageMonitorPacket).getName());
    public static final int DEFAULT_PORT = 4810;
    public static final int MAX_PACKET_SIZE = 1472;
    protected short componentCode;
    protected short packetVersion;
    protected byte[] binaryContents;
    static /* synthetic */ Class class$org$globus$usage$packets$UsageMonitorPacket;

    public void setComponentCode(short c) {
        this.componentCode = c;
    }

    public short getComponentCode() {
        return this.componentCode;
    }

    public void setPacketVersion(short v) {
        this.packetVersion = v;
    }

    public short getPacketVersion() {
        return this.packetVersion;
    }

    public byte[] getBinaryContents() {
        return this.binaryContents;
    }

    public void packCustomFields(CustomByteBuffer buf) {
    }

    public void unpackCustomFields(CustomByteBuffer buf) {
    }

    private byte[] toByteArray() {
        CustomByteBuffer buf = new CustomByteBuffer(1472);
        buf.putShort(this.componentCode);
        buf.putShort(this.packetVersion);
        this.packCustomFields(buf);
        return buf.array();
    }

    public void parseByteArray(byte[] input) {
        CustomByteBuffer buf = CustomByteBuffer.wrap(input);
        this.componentCode = buf.getShort();
        this.packetVersion = buf.getShort();
        this.unpackCustomFields(buf);
        this.binaryContents = input;
    }

    public void sendPacket(DatagramSocket socket, InetAddress destination, int destPort) throws IOException {
        byte[] sendBuf = this.toByteArray();
        DatagramPacket packet = new DatagramPacket(sendBuf, sendBuf.length, destination, destPort);
        socket.send(packet);
    }

    public void sendPacketToMultiple(DatagramSocket socket, InetAddress[] destinations, int[] destPorts) throws IOException {
        if (destinations.length != destPorts.length) {
            throw new IllegalArgumentException("Number of destinations and destination ports do not match");
        }
        byte[] sendBuf = this.toByteArray();
        for (int i = 0; i < destinations.length; ++i) {
            socket.send(new DatagramPacket(sendBuf, sendBuf.length, destinations[i], destPorts[i]));
        }
    }

    public void sendPacketToMultiple(DatagramSocket socket, InetAddress[] destinations, int destPort) throws IOException {
        byte[] sendBuf = this.toByteArray();
        for (int i = 0; i < destinations.length; ++i) {
            socket.send(new DatagramPacket(sendBuf, sendBuf.length, destinations[i], destPort));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(InetAddress destination, int destPort) throws IOException {
        DatagramSocketFactory factory = DatagramSocketFactory.getDefault();
        DatagramSocket socket = null;
        try {
            socket = factory.createDatagramSocket();
            this.sendPacket(socket, destination, destPort);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacketToMultiple(InetAddress[] destinations, int[] destPorts) throws IOException {
        DatagramSocketFactory factory = DatagramSocketFactory.getDefault();
        DatagramSocket socket = null;
        try {
            socket = factory.createDatagramSocket();
            this.sendPacketToMultiple(socket, destinations, destPorts);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacketToMultiple(InetAddress[] destinations, int destPort) throws IOException {
        DatagramSocketFactory factory = DatagramSocketFactory.getDefault();
        DatagramSocket socket = null;
        try {
            socket = factory.createDatagramSocket();
            this.sendPacketToMultiple(socket, destinations, destPort);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    public void sendPacket(List targets) {
        Iterator iter = targets.iterator();
        while (iter.hasNext()) {
            String hostport = (String)iter.next();
            hostport = hostport.trim();
            int colon = hostport.indexOf(58);
            String host = null;
            int port = -1;
            if (colon == -1) {
                host = hostport;
                port = 4810;
            } else {
                host = hostport.substring(0, colon);
                port = Integer.parseInt(hostport.substring(colon + 1));
            }
            try {
                InetAddress addr = InetAddress.getByName(host);
                this.sendPacket(addr, port);
            }
            catch (Throwable e) {
                log.debug((Object)"Failed to send packet", e);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("component code: " + this.componentCode);
        buf.append(", component packet version: " + this.packetVersion);
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

