/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.permission;

import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionParser;

public class ChmodParser
extends PermissionParser {
    private static Pattern chmodOctalPattern = Pattern.compile("^\\s*[+]?([0-7]{3})\\s*$");
    private static Pattern chmodNormalPattern = Pattern.compile("\\G\\s*([ugoa]*)([+=-]+)([rwxX]+)([,\\s]*)\\s*");

    public ChmodParser(String modeStr) throws IllegalArgumentException {
        super(modeStr, chmodNormalPattern, chmodOctalPattern);
    }

    public short applyNewPermission(FileStatus file) {
        FsPermission perms = file.getPermission();
        short existing = perms.toShort();
        boolean exeOk = file.isDir() || (existing & 0x49) != 0;
        return (short)this.combineModes(existing, exeOk);
    }
}

