/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.fusesource.hawtdispatch.CustomDispatchSource;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.EventAggregator;
import org.fusesource.hawtdispatch.EventAggregators;
import org.fusesource.hawtdispatch.transport.PipeTransport;
import org.fusesource.hawtdispatch.transport.PipeTransportRegistry;
import org.fusesource.hawtdispatch.transport.TransportServer;
import org.fusesource.hawtdispatch.transport.TransportServerListener;

public class PipeTransportServer
implements TransportServer {
    protected String connectURI;
    protected TransportServerListener listener;
    protected String name;
    protected boolean marshal;
    protected final AtomicInteger connectionCounter = new AtomicInteger();
    DispatchQueue dispatchQueue;
    private CustomDispatchSource<PipeTransport, LinkedList<PipeTransport>> acceptSource;

    public String getBoundAddress() {
        return this.connectURI;
    }

    public InetSocketAddress getSocketAddress() {
        return null;
    }

    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    public void setDispatchQueue(DispatchQueue queue) {
        this.dispatchQueue = queue;
    }

    public void suspend() {
        this.acceptSource.suspend();
    }

    public void resume() {
        this.acceptSource.resume();
    }

    public void setTransportServerListener(TransportServerListener listener) {
        this.listener = listener;
    }

    public void start() throws Exception {
        this.start(null);
    }

    public void start(Runnable onCompleted) throws Exception {
        this.acceptSource = Dispatch.createSource((EventAggregator)EventAggregators.linkedList(), (DispatchQueue)this.dispatchQueue);
        this.acceptSource.setEventHandler(new Runnable(){

            public void run() {
                LinkedList transports = (LinkedList)PipeTransportServer.this.acceptSource.getData();
                for (PipeTransport transport : transports) {
                    try {
                        PipeTransportServer.this.listener.onAccept(transport);
                    }
                    catch (Exception e) {
                        PipeTransportServer.this.listener.onAcceptError(e);
                    }
                }
            }
        });
        this.acceptSource.resume();
        if (onCompleted != null) {
            this.dispatchQueue.execute(onCompleted);
        }
    }

    public void stop() throws Exception {
        this.stop(null);
    }

    public void stop(Runnable onCompleted) throws Exception {
        PipeTransportRegistry.unbind(this);
        this.acceptSource.setCancelHandler(onCompleted);
        this.acceptSource.cancel();
    }

    public void setConnectURI(String connectURI) {
        this.connectURI = connectURI;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PipeTransport connect() {
        PipeTransport serverTransport;
        int connectionId = this.connectionCounter.incrementAndGet();
        String remoteAddress = this.connectURI.toString() + "#" + connectionId;
        assert (this.listener != null) : "Server does not have an accept listener";
        PipeTransport clientTransport = this.createClientTransport();
        clientTransport.peer = serverTransport = this.createServerTransport();
        serverTransport.peer = clientTransport;
        clientTransport.setRemoteAddress(remoteAddress);
        serverTransport.setRemoteAddress(remoteAddress);
        serverTransport.setMarshal(this.marshal);
        this.acceptSource.merge((Object)serverTransport);
        return clientTransport;
    }

    protected PipeTransport createClientTransport() {
        return new PipeTransport(this);
    }

    protected PipeTransport createServerTransport() {
        return new PipeTransport(this);
    }

    public boolean isMarshal() {
        return this.marshal;
    }

    public void setMarshal(boolean marshal) {
        this.marshal = marshal;
    }
}

