/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParentNode;

public abstract class Node {
    private ParentNode parent = null;

    Node() {
    }

    public abstract String getValue();

    public final Document getDocument() {
        Node node;
        for (node = this; node != null && !node.isDocument(); node = node.getParent()) {
        }
        return (Document)node;
    }

    public String getBaseURI() {
        ParentNode parentNode = this.getParent();
        if (parentNode == null) {
            return "";
        }
        return parentNode.getBaseURI();
    }

    public final ParentNode getParent() {
        return this.parent;
    }

    final void setParent(ParentNode parentNode) {
        this.parent = parentNode;
    }

    public void detach() {
        if (this.parent == null) {
            return;
        }
        if (this.isAttribute()) {
            Element element = (Element)this.parent;
            element.removeAttribute((Attribute)this);
        } else {
            this.parent.removeChild(this);
        }
    }

    public abstract Node getChild(int var1);

    public abstract int getChildCount();

    public abstract Node copy();

    public abstract String toXML();

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    boolean isElement() {
        return false;
    }

    boolean isText() {
        return false;
    }

    boolean isComment() {
        return false;
    }

    boolean isProcessingInstruction() {
        return false;
    }

    boolean isAttribute() {
        return false;
    }

    boolean isDocument() {
        return false;
    }

    boolean isDocType() {
        return false;
    }
}

