/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms;

public class FQAN {
    String fqan;
    String group;
    String role;
    String capability;
    boolean split = false;

    public FQAN(String fqan) {
        this.fqan = fqan;
    }

    public FQAN(String group, String role, String capability) {
        this.group = group;
        this.role = role;
        this.capability = capability;
        this.split = true;
    }

    public String getFQAN() {
        if (this.fqan != null) {
            return this.fqan;
        }
        this.fqan = this.group + "/Role=" + (this.role != null ? this.role : "") + (this.capability != null ? "/Capability=" + this.capability : "");
        return this.fqan;
    }

    protected void split() {
        if (this.split) {
            return;
        }
        this.split = true;
        if (this.fqan == null) {
            return;
        }
        int len = this.fqan.length();
        int i = this.fqan.indexOf("/Role=");
        if (i < 0) {
            this.group = this.fqan;
            return;
        }
        this.group = this.fqan.substring(0, i);
        int j = this.fqan.indexOf("/Capability=", i + 6);
        String s = j < 0 ? this.fqan.substring(i + 6) : this.fqan.substring(i + 6, j);
        this.role = s.length() == 0 ? null : s;
        s = j < 0 ? null : this.fqan.substring(j + 12);
        this.capability = s == null || s.length() == 0 ? null : s;
    }

    public String getGroup() {
        if (!this.split) {
            this.split();
        }
        return this.group;
    }

    public String getRole() {
        if (!this.split) {
            this.split();
        }
        return this.role;
    }

    public String getCapability() {
        if (!this.split) {
            this.split();
        }
        return this.capability;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof FQAN || o instanceof String) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public String toString() {
        return this.getFQAN();
    }
}

