/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.journal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.JournalQueueAck;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.filter.NonCachedMessageEvaluationContext;
import org.apache.activemq.store.AbstractMessageStore;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.journal.JournalPersistenceAdapter;
import org.apache.activemq.store.journal.JournalTransactionStore;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.util.Callback;
import org.apache.activemq.util.TransactionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalMessageStore
extends AbstractMessageStore {
    private static final Logger LOG = LoggerFactory.getLogger(JournalMessageStore.class);
    protected final JournalPersistenceAdapter peristenceAdapter;
    protected final JournalTransactionStore transactionStore;
    protected final MessageStore longTermStore;
    protected final TransactionTemplate transactionTemplate;
    protected RecordLocation lastLocation;
    protected Set<RecordLocation> inFlightTxLocations = new HashSet<RecordLocation>();
    private Map<MessageId, Message> messages = new LinkedHashMap<MessageId, Message>();
    private List<MessageAck> messageAcks = new ArrayList<MessageAck>();
    private Map<MessageId, Message> cpAddedMessageIds;
    private MemoryUsage memoryUsage;

    public JournalMessageStore(JournalPersistenceAdapter adapter, MessageStore checkpointStore, ActiveMQDestination destination) {
        super(destination);
        this.peristenceAdapter = adapter;
        this.transactionStore = adapter.getTransactionStore();
        this.longTermStore = checkpointStore;
        this.transactionTemplate = new TransactionTemplate(adapter, new ConnectionContext(new NonCachedMessageEvaluationContext()));
    }

    @Override
    public void setMemoryUsage(MemoryUsage memoryUsage) {
        this.memoryUsage = memoryUsage;
        this.longTermStore.setMemoryUsage(memoryUsage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(ConnectionContext context, final Message message) throws IOException {
        final MessageId id = message.getMessageId();
        final boolean debug = LOG.isDebugEnabled();
        message.incrementReferenceCount();
        final RecordLocation location = this.peristenceAdapter.writeCommand(message, message.isResponseRequired());
        if (!context.isInTransaction()) {
            if (debug) {
                LOG.debug("Journalled message add for: " + id + ", at: " + location);
            }
            this.addMessage(message, location);
        } else {
            if (debug) {
                LOG.debug("Journalled transacted message add for: " + id + ", at: " + location);
            }
            JournalMessageStore journalMessageStore = this;
            synchronized (journalMessageStore) {
                this.inFlightTxLocations.add(location);
            }
            this.transactionStore.addMessage(this, message, location);
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void afterCommit() throws Exception {
                    if (debug) {
                        LOG.debug("Transacted message add commit for: " + id + ", at: " + location);
                    }
                    JournalMessageStore journalMessageStore = JournalMessageStore.this;
                    synchronized (journalMessageStore) {
                        JournalMessageStore.this.inFlightTxLocations.remove(location);
                        JournalMessageStore.this.addMessage(message, location);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void afterRollback() throws Exception {
                    if (debug) {
                        LOG.debug("Transacted message add rollback for: " + id + ", at: " + location);
                    }
                    JournalMessageStore journalMessageStore = JournalMessageStore.this;
                    synchronized (journalMessageStore) {
                        JournalMessageStore.this.inFlightTxLocations.remove(location);
                    }
                    message.decrementReferenceCount();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessage(Message message, RecordLocation location) {
        JournalMessageStore journalMessageStore = this;
        synchronized (journalMessageStore) {
            this.lastLocation = location;
            MessageId id = message.getMessageId();
            this.messages.put(id, message);
        }
    }

    public void replayAddMessage(ConnectionContext context, Message message) {
        try {
            Message t = this.longTermStore.getMessage(message.getMessageId());
            if (t == null) {
                this.longTermStore.addMessage(context, message);
            }
        }
        catch (Throwable e) {
            LOG.warn("Could not replay add for message '" + message.getMessageId() + "'.  Message may have already been added. reason: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessage(ConnectionContext context, final MessageAck ack) throws IOException {
        final boolean debug = LOG.isDebugEnabled();
        JournalQueueAck remove = new JournalQueueAck();
        remove.setDestination(this.destination);
        remove.setMessageAck(ack);
        final RecordLocation location = this.peristenceAdapter.writeCommand(remove, ack.isResponseRequired());
        if (!context.isInTransaction()) {
            if (debug) {
                LOG.debug("Journalled message remove for: " + ack.getLastMessageId() + ", at: " + location);
            }
            this.removeMessage(ack, location);
        } else {
            if (debug) {
                LOG.debug("Journalled transacted message remove for: " + ack.getLastMessageId() + ", at: " + location);
            }
            JournalMessageStore journalMessageStore = this;
            synchronized (journalMessageStore) {
                this.inFlightTxLocations.add(location);
            }
            this.transactionStore.removeMessage(this, ack, location);
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void afterCommit() throws Exception {
                    if (debug) {
                        LOG.debug("Transacted message remove commit for: " + ack.getLastMessageId() + ", at: " + location);
                    }
                    JournalMessageStore journalMessageStore = JournalMessageStore.this;
                    synchronized (journalMessageStore) {
                        JournalMessageStore.this.inFlightTxLocations.remove(location);
                        JournalMessageStore.this.removeMessage(ack, location);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void afterRollback() throws Exception {
                    if (debug) {
                        LOG.debug("Transacted message remove rollback for: " + ack.getLastMessageId() + ", at: " + location);
                    }
                    JournalMessageStore journalMessageStore = JournalMessageStore.this;
                    synchronized (journalMessageStore) {
                        JournalMessageStore.this.inFlightTxLocations.remove(location);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeMessage(MessageAck ack, RecordLocation location) {
        JournalMessageStore journalMessageStore = this;
        synchronized (journalMessageStore) {
            this.lastLocation = location;
            MessageId id = ack.getLastMessageId();
            Message message = this.messages.remove(id);
            if (message == null) {
                this.messageAcks.add(ack);
            } else {
                message.decrementReferenceCount();
            }
        }
    }

    public void replayRemoveMessage(ConnectionContext context, MessageAck messageAck) {
        try {
            Message t = this.longTermStore.getMessage(messageAck.getLastMessageId());
            if (t != null) {
                this.longTermStore.removeMessage(context, messageAck);
            }
        }
        catch (Throwable e) {
            LOG.warn("Could not replay acknowledge for message '" + messageAck.getLastMessageId() + "'.  Message may have already been acknowledged. reason: " + e);
        }
    }

    public RecordLocation checkpoint() throws IOException {
        return this.checkpoint(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordLocation checkpoint(final Callback postCheckpointTest) throws IOException {
        ArrayList<RecordLocation> cpActiveJournalLocations;
        List<MessageAck> cpRemovedMessageLocations;
        final int maxCheckpointMessageAddSize = this.peristenceAdapter.getMaxCheckpointMessageAddSize();
        JournalMessageStore journalMessageStore = this;
        synchronized (journalMessageStore) {
            this.cpAddedMessageIds = this.messages;
            cpRemovedMessageLocations = this.messageAcks;
            cpActiveJournalLocations = new ArrayList<RecordLocation>(this.inFlightTxLocations);
            this.messages = new LinkedHashMap<MessageId, Message>();
            this.messageAcks = new ArrayList<MessageAck>();
        }
        this.transactionTemplate.run(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                int size = 0;
                PersistenceAdapter persitanceAdapter = JournalMessageStore.this.transactionTemplate.getPersistenceAdapter();
                ConnectionContext context = JournalMessageStore.this.transactionTemplate.getContext();
                JournalMessageStore journalMessageStore = JournalMessageStore.this;
                synchronized (journalMessageStore) {
                    for (Message message : JournalMessageStore.this.cpAddedMessageIds.values()) {
                        try {
                            JournalMessageStore.this.longTermStore.addMessage(context, message);
                        }
                        catch (Throwable e) {
                            LOG.warn("Message could not be added to long term store: " + e.getMessage(), e);
                        }
                        message.decrementReferenceCount();
                        if ((size += message.getSize()) < maxCheckpointMessageAddSize) continue;
                        persitanceAdapter.commitTransaction(context);
                        persitanceAdapter.beginTransaction(context);
                        size = 0;
                    }
                }
                persitanceAdapter.commitTransaction(context);
                persitanceAdapter.beginTransaction(context);
                Iterator iterator = cpRemovedMessageLocations.iterator();
                while (iterator.hasNext()) {
                    try {
                        MessageAck ack = (MessageAck)iterator.next();
                        JournalMessageStore.this.longTermStore.removeMessage(JournalMessageStore.this.transactionTemplate.getContext(), ack);
                    }
                    catch (Throwable e) {
                        LOG.debug("Message could not be removed from long term store: " + e.getMessage(), e);
                    }
                }
                if (postCheckpointTest != null) {
                    postCheckpointTest.execute();
                }
            }
        });
        journalMessageStore = this;
        synchronized (journalMessageStore) {
            this.cpAddedMessageIds = null;
        }
        if (cpActiveJournalLocations.size() > 0) {
            Collections.sort(cpActiveJournalLocations);
            return (RecordLocation)cpActiveJournalLocations.get(0);
        }
        journalMessageStore = this;
        synchronized (journalMessageStore) {
            return this.lastLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message getMessage(MessageId identity) throws IOException {
        Message answer = null;
        JournalMessageStore journalMessageStore = this;
        synchronized (journalMessageStore) {
            answer = this.messages.get(identity);
            if (answer == null && this.cpAddedMessageIds != null) {
                answer = this.cpAddedMessageIds.get(identity);
            }
        }
        if (answer != null) {
            return answer;
        }
        return this.longTermStore.getMessage(identity);
    }

    @Override
    public void recover(MessageRecoveryListener listener) throws Exception {
        this.peristenceAdapter.checkpoint(true, true);
        this.longTermStore.recover(listener);
    }

    @Override
    public void start() throws Exception {
        if (this.memoryUsage != null) {
            this.memoryUsage.addUsageListener(this.peristenceAdapter);
        }
        this.longTermStore.start();
    }

    @Override
    public void stop() throws Exception {
        this.longTermStore.stop();
        if (this.memoryUsage != null) {
            this.memoryUsage.removeUsageListener(this.peristenceAdapter);
        }
    }

    public MessageStore getLongTermMessageStore() {
        return this.longTermStore;
    }

    @Override
    public void removeAllMessages(ConnectionContext context) throws IOException {
        this.peristenceAdapter.checkpoint(true, true);
        this.longTermStore.removeAllMessages(context);
    }

    public void addMessageReference(ConnectionContext context, MessageId messageId, long expirationTime, String messageRef) throws IOException {
        throw new IOException("The journal does not support message references.");
    }

    public String getMessageReference(MessageId identity) throws IOException {
        throw new IOException("The journal does not support message references.");
    }

    @Override
    public int getMessageCount() throws IOException {
        this.peristenceAdapter.checkpoint(true, true);
        return this.longTermStore.getMessageCount();
    }

    @Override
    public void recoverNextMessages(int maxReturned, MessageRecoveryListener listener) throws Exception {
        this.peristenceAdapter.checkpoint(true, true);
        this.longTermStore.recoverNextMessages(maxReturned, listener);
    }

    @Override
    public void resetBatching() {
        this.longTermStore.resetBatching();
    }

    @Override
    public void setBatch(MessageId messageId) throws Exception {
        this.peristenceAdapter.checkpoint(true, true);
        this.longTermStore.setBatch(messageId);
    }
}

