/*
 * Decompiled with CFR 0.152.
 */
package org.globus.usage.packets;

import java.util.HashMap;

public class PacketFieldParser {
    HashMap pairs;

    public PacketFieldParser() {
    }

    public PacketFieldParser(String input) {
        this.parseString(input);
    }

    public void parseString(String input) {
        boolean containsQuotes = false;
        this.pairs = new HashMap();
        String[] substrings = input.split("\"");
        for (int i = 0; i < substrings.length; i += 2) {
            String nonQuoted = substrings[i];
            String quoted = i + 1 < substrings.length ? substrings[i + 1] : null;
            String[] fields = nonQuoted.split(" ");
            for (int j = 0; j < fields.length; ++j) {
                String[] temp = fields[j].split("=");
                if (temp.length > 1) {
                    this.pairs.put(temp[0], temp[1]);
                    continue;
                }
                if (j != fields.length - 1 || quoted == null) continue;
                this.pairs.put(temp[0], quoted);
            }
        }
    }

    public int countFields() {
        return this.pairs.size();
    }

    public int getInt(String key) {
        if (!this.pairs.containsKey(key)) {
            return 0;
        }
        return Integer.parseInt((String)this.pairs.get(key));
    }

    public long getLong(String key) {
        if (!this.pairs.containsKey(key)) {
            return 0L;
        }
        return Long.parseLong((String)this.pairs.get(key));
    }

    public double getDouble(String key) {
        if (!this.pairs.containsKey(key)) {
            return 0.0;
        }
        return Double.parseDouble((String)this.pairs.get(key));
    }

    public String getString(String key) {
        if (!this.pairs.containsKey(key)) {
            return "";
        }
        return (String)this.pairs.get(key);
    }
}

