/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.operators.patch;

import java.io.File;
import java.util.HashMap;
import org.gcube.common.vremanagement.deployer.impl.contexts.Configuration;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntInterfaceException;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntRunner;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InvalidPackageArchiveException;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.BaseExtractor;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.Downloader;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DeployablePackage;

public class PatchExtractor
extends BaseExtractor {
    public PatchExtractor(Downloader downloader) throws Exception {
        super(downloader);
    }

    protected void manageDownloadedFile() throws DeployException, InvalidPackageArchiveException {
        String destDir = Configuration.BASEPATCHDIR + File.separator + "patch_" + this.downloader.packagename;
        try {
            this.run = new AntRunner();
            this.run.init(Configuration.DEPLOYFILE, Configuration.BASEDIR);
        }
        catch (Exception e) {
            this.logger.error((Object)"Deployer is unable to initialize the patching environment", (Throwable)e);
            throw new DeployException("Deployer is unable to initialize the patching environment");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            properties.put("folder", destDir);
            this.run.setProperties(properties, true);
            this.run.runTarget("createFolder");
        }
        catch (AntInterfaceException aie) {
            throw new DeployException(aie.getMessage());
        }
        properties = new HashMap();
        properties.put("package.file", this.getDownloadedFile().getName().trim());
        properties.put("service.id", this.downloader.getServiceKey());
        properties.put("package.source.dir", Configuration.BASEPATCHDIR);
        properties.put("base.deploy.dir", destDir);
        try {
            this.run.setProperties(properties, true);
            this.run.runTarget("uncompressPackage");
        }
        catch (AntInterfaceException aie) {
            throw new DeployException(aie.getMessage());
        }
    }

    public String getPatchFolder() throws DeployException, InvalidPackageArchiveException {
        this.manageDownloadedFile();
        return Configuration.BASEPATCHDIR + File.separator + "patch_" + this.downloader.packagename + File.separator + this.downloader.getServiceKey();
    }

    @Override
    public DeployablePackage getPackage() throws InvalidPackageArchiveException, Exception {
        throw new Exception("method not implemented for patches");
    }
}

