/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.kxml.service;

import java.net.URI;
import org.gcube.common.core.resources.service.Software;
import org.gcube.common.resources.kxml.KGCUBEResource;
import org.gcube.common.resources.kxml.service.KPackage;
import org.gcube.common.resources.kxml.utils.KStringList;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class KSoftware {
    /*
     * Enabled aggressive block sorting
     */
    public static Software load(KXmlParser parser) throws Exception {
        Software software = new Software();
        while (true) {
            switch (parser.next()) {
                case 2: {
                    KPackage.load(software, parser);
                    if (parser.getName().equals("Type")) {
                        software.setType(Software.Type.valueOf(parser.nextText()));
                    }
                    if (parser.getName().equals("EntryPoint")) {
                        software.getEntrypoints().add(parser.nextText().trim());
                    }
                    if (parser.getName().equals("Files")) {
                        software.setFiles(KStringList.load("Files", parser));
                    }
                    if (!parser.getName().equals("URI")) break;
                    software.setURI(new URI(parser.nextText()));
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("Software")) break;
                    return software;
                }
                case 1: {
                    throw new Exception("Parsing failed at Software");
                }
            }
        }
    }

    public static void store(Software component, KXmlSerializer serializer) throws Exception {
        if (component == null) {
            return;
        }
        serializer.startTag(KGCUBEResource.NS, "Software");
        KPackage.store(component, serializer);
        if (component.getType() != null) {
            serializer.startTag(KGCUBEResource.NS, "Type").text(component.getType().toString()).endTag(KGCUBEResource.NS, "Type");
        }
        if (component.getEntrypoints().size() != 0) {
            for (String entry : component.getEntrypoints()) {
                serializer.startTag(KGCUBEResource.NS, "EntryPoint").text(entry).endTag(KGCUBEResource.NS, "EntryPoint");
            }
        }
        if (component.getFiles() != null) {
            KStringList.store("Files", "File", component.getFiles(), serializer);
        }
        if (component.getURI() != null) {
            serializer.startTag(KGCUBEResource.NS, "URI").text(component.getURI().toString()).endTag(KGCUBEResource.NS, "URI");
        }
        serializer.endTag(KGCUBEResource.NS, "Software");
    }
}

