/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.contexts;

import java.io.File;
import javax.xml.namespace.QName;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.utils.XMLUtils;
import org.gcube.common.core.contexts.GCUBEContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.service.Consumer;
import org.gcube.common.core.security.GCUBEDefaultSecurityConfiguration;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.globus.wsrf.utils.AddressingUtils;
import org.xml.sax.InputSource;

public abstract class GCUBEPortTypeContext
extends GCUBEContext {
    protected static String WSDD_FILE_NAME = "deploy-server.wsdd";
    protected static String WSSD_WSDD_NAME = "securityDescriptor";
    protected String name;
    protected WSDDService deploymentDescriptor;
    protected ServiceSecurityDescriptor securityDescriptor;

    public GCUBEPortTypeContext() {
        if (this.getServiceContext().getStatus() == GCUBEServiceContext.Status.FAILED) {
            return;
        }
        try {
            this.getServiceContext().subscribeLifetTime(new PTConsumer(), new GCUBEServiceContext.RILifetimeTopic[0]);
        }
        catch (Exception e) {
            this.logger.fatal("could not register porttype for RI lifetime event", e);
            this.getServiceContext().setStatus(GCUBEServiceContext.Status.FAILED);
        }
    }

    public EndpointReferenceType getEPR() throws Exception {
        return AddressingUtils.createEndpointReference((String)(GHNContext.getContext().getBaseURL() + this.getJNDIName()), null);
    }

    @Override
    public synchronized String getName() {
        if (this.name == null) {
            this.name = new File(this.getJNDIName()).getName();
        }
        return this.name;
    }

    @Override
    public Object getProperty(String prop, boolean ... required) throws RuntimeException {
        return super.getProperty("java:comp/env//services/" + this.getJNDIName() + "/" + prop, required);
    }

    public WSDDService getDeploymentDescriptor() {
        if (this.deploymentDescriptor == null) {
            try {
                WSDDDocument doc = new WSDDDocument(XMLUtils.newDocument((InputSource)new InputSource(this.getFile(WSDD_FILE_NAME, new boolean[0]).getAbsolutePath())));
                this.deploymentDescriptor = doc.getDeployment().getWSDDService(new QName(null, this.getJNDIName()));
            }
            catch (Exception e) {
                this.logger.error("could not load deployment descriptor", e);
            }
        }
        return this.deploymentDescriptor;
    }

    public ServiceSecurityDescriptor getSecurityDescriptor() {
        block5: {
            this.logger.debug("Getting the security descriptor");
            if (this.securityDescriptor == null) {
                try {
                    this.logger.debug("Triyng to load the security descriptor...");
                    GCUBEDefaultSecurityConfiguration securityConfiguration = SecurityContextFactory.getInstance().getSecurityContext().getDefaultServiceSecurityConfiguration();
                    String securityDescriptorFileName = this.deploymentDescriptor.getParameter(WSSD_WSDD_NAME);
                    if (securityConfiguration != null && securityConfiguration.isInEnabled() && securityConfiguration.isInOverride() || securityConfiguration != null && securityConfiguration.isInEnabled() && securityDescriptorFileName == null) {
                        this.logger.debug("Ingoing override = " + securityConfiguration.isInOverride());
                        this.logger.debug("sec desc file = " + securityDescriptorFileName);
                        this.logger.debug("Loading default ingoing security descriptor");
                        this.securityDescriptor = SecurityContextFactory.getInstance().getSecurityContext().getDefaultIncomingMessagesSecurityDescriptor();
                        this.logger.debug("Security descriptor = " + this.securityDescriptor);
                        break block5;
                    }
                    if (securityDescriptorFileName != null) {
                        this.logger.debug("loading from the file");
                        this.securityDescriptor = new ServiceSecurityDescriptor();
                        this.securityDescriptor.parse(ServiceSecurityConfig.loadSecurityDescriptor((String)securityDescriptorFileName).getDocumentElement());
                        break block5;
                    }
                    this.logger.debug("No security descriptor for this port type");
                    return null;
                }
                catch (Exception e) {
                    this.logger.error("could not load security descriptor", e);
                }
            }
        }
        return this.securityDescriptor;
    }

    @Override
    public File getFile(String path, boolean ... writeMode) {
        return this.getServiceContext().getFile(path, writeMode);
    }

    public File getPersistentFile(String path, boolean ... writeMode) throws IllegalArgumentException {
        return this.getServiceContext().getPersistentFile(this.getName() + File.separatorChar + path, writeMode);
    }

    public abstract String getJNDIName();

    public abstract String getNamespace();

    public abstract GCUBEServiceContext getServiceContext();

    protected void onInitialisation() throws Exception {
    }

    protected void onReady() throws Exception {
    }

    protected void onUpdate() throws Exception {
    }

    protected void onStateChange() throws Exception {
    }

    protected void onFailure() throws Exception {
    }

    protected class PTConsumer
    extends Consumer {
        PTConsumer() {
            this.consumerLogger = GCUBEPortTypeContext.this.logger;
        }

        @Override
        protected void onRIInitialised(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIInitialised(event);
            GCUBEPortTypeContext.this.logger.setContext(GCUBEPortTypeContext.this.getServiceContext());
            GCUBEPortTypeContext.this.onInitialisation();
        }

        @Override
        protected void onRIReady(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIReady(event);
            GCUBEPortTypeContext.this.onReady();
        }

        @Override
        protected void onRIStateChange(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIStateChange(event);
            GCUBEPortTypeContext.this.onStateChange();
        }

        @Override
        protected void onRIUpdated(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIUpdated(event);
            GCUBEPortTypeContext.this.onUpdate();
        }

        @Override
        protected void onRIFailed(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIFailed(event);
            GCUBEPortTypeContext.this.onFailure();
        }
    }
}

