/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.proxy;

import java.awt.FlowLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.globus.common.CoGProperties;
import org.globus.tools.ui.util.FileBrowser;
import org.globus.tools.ui.util.JJPanel;

public class ProxyOptionsPanel
extends JJPanel {
    protected FileBrowser proxyFileFB;
    protected ButtonGroup hoursGroup;
    protected ButtonGroup bitsGroup;
    protected JRadioButton shRB;
    protected JRadioButton mhRB;
    protected JRadioButton lhRB;
    protected JRadioButton ghRB;
    protected JRadioButton otherRB;
    protected JRadioButton sbRB;
    protected JRadioButton mbRB;
    protected JRadioButton lbRB;
    protected JRadioButton gbRB;
    private JTextField otherTF;

    public ProxyOptionsPanel() {
        this.setAnchor(13);
        this.add(new JLabel("Proxy Lifetime: "), 0, 0, 1, 1);
        this.add(new JLabel("Strength: "), 0, 1, 1, 1);
        this.add(new JLabel("Proxy File: "), 0, 2, 1, 1);
        this.setAnchor(17);
        this.gbc.weightx = 1.0;
        this.setFill(2);
        JPanel hoursPanel = new JPanel(new FlowLayout(0, 2, 0));
        this.shRB = new JRadioButton("12 h");
        this.mhRB = new JRadioButton("24 h", true);
        this.lhRB = new JRadioButton("1 week");
        this.ghRB = new JRadioButton("1 month");
        this.otherRB = new JRadioButton();
        this.shRB.setActionCommand("12");
        this.mhRB.setActionCommand("24");
        this.lhRB.setActionCommand("168");
        this.ghRB.setActionCommand("672");
        this.otherRB.setActionCommand("other");
        this.hoursGroup = new ButtonGroup();
        this.hoursGroup.add(this.shRB);
        this.hoursGroup.add(this.mhRB);
        this.hoursGroup.add(this.lhRB);
        this.hoursGroup.add(this.ghRB);
        this.hoursGroup.add(this.otherRB);
        this.otherTF = new JTextField(3);
        this.otherTF.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ProxyOptionsPanel.this.otherRB.setSelected(true);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        hoursPanel.add(this.shRB);
        hoursPanel.add(this.mhRB);
        hoursPanel.add(this.lhRB);
        hoursPanel.add(this.ghRB);
        hoursPanel.add(this.otherRB);
        hoursPanel.add(this.otherTF);
        hoursPanel.add(new JLabel("h"));
        this.add(hoursPanel, 1, 0, 1, 1);
        JPanel bitsPanel = new JPanel(new FlowLayout(0, 2, 0));
        this.sbRB = new JRadioButton("512", true);
        this.mbRB = new JRadioButton("1024");
        this.lbRB = new JRadioButton("2048");
        this.gbRB = new JRadioButton("4096");
        this.sbRB.setActionCommand("512");
        this.mbRB.setActionCommand("1024");
        this.lbRB.setActionCommand("2048");
        this.gbRB.setActionCommand("4096");
        this.bitsGroup = new ButtonGroup();
        this.bitsGroup.add(this.sbRB);
        this.bitsGroup.add(this.mbRB);
        this.bitsGroup.add(this.lbRB);
        this.bitsGroup.add(this.gbRB);
        bitsPanel.add(this.sbRB);
        bitsPanel.add(this.mbRB);
        bitsPanel.add(this.lbRB);
        bitsPanel.add(this.gbRB);
        this.add(bitsPanel, 1, 1, 1, 1);
        this.proxyFileFB = new FileBrowser("Select Grid Proxy File", "Select");
        this.add(this.proxyFileFB, 1, 2, 1, 1);
    }

    protected boolean error(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Need More Information", 2);
        return false;
    }

    public boolean validateSettings() {
        if (this.proxyFileFB.getFile().equals("")) {
            return this.error("Please enter the proxy file location");
        }
        return true;
    }

    public void set(CoGProperties props) {
        this.proxyFileFB.setFile(props.getProxyFile());
        int value = props.getProxyLifeTime();
        if (value == 12) {
            this.shRB.setSelected(true);
        } else if (value == 24) {
            this.mhRB.setSelected(true);
        } else if (value == 168) {
            this.lhRB.setSelected(true);
        } else if (value == 672) {
            this.ghRB.setSelected(true);
        } else {
            this.otherTF.setText(String.valueOf(value));
            this.otherRB.setSelected(true);
        }
        value = props.getProxyStrength();
        if (value == 512) {
            this.sbRB.setSelected(true);
        } else if (value == 1024) {
            this.mbRB.setSelected(true);
        } else if (value == 2048) {
            this.lbRB.setSelected(true);
        } else if (value == 4096) {
            this.gbRB.setSelected(true);
        } else {
            this.sbRB.setSelected(true);
        }
    }

    public void get(CoGProperties props) {
        props.setProxyStrength(Integer.parseInt(this.bitsGroup.getSelection().getActionCommand()));
        props.setProxyFile(this.proxyFileFB.getFile());
        if (this.otherRB.isSelected()) {
            props.setProxyLifeTime(Integer.parseInt(this.otherTF.getText().trim()));
        } else {
            props.setProxyLifeTime(Integer.parseInt(this.hoursGroup.getSelection().getActionCommand()));
        }
    }
}

