/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authorization;

import java.io.Serializable;
import java.util.ArrayList;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import org.apache.axis.AxisFault;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authorization.InterceptorConfig;
import org.globus.wsrf.impl.security.authorization.exceptions.AuthorizationException;
import org.globus.wsrf.impl.security.authorization.exceptions.CloseException;
import org.globus.wsrf.impl.security.authorization.exceptions.InitializeException;
import org.globus.wsrf.impl.security.authorization.exceptions.InvalidPolicyException;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.security.SecurityException;
import org.globus.wsrf.security.authorization.Interceptor;
import org.globus.wsrf.security.authorization.PDP;
import org.globus.wsrf.security.authorization.PDPConfig;
import org.globus.wsrf.security.authorization.PIP;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceAuthorizationChain
implements Interceptor,
Serializable {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authorization.errors", (ClassLoader)ServiceAuthorizationChain.class.getClassLoader());
    private static Log logger = LogFactory.getLog((String)ServiceAuthorizationChain.class.getName());
    protected boolean initialized;
    protected Interceptor[] interceptor;
    protected String[] interceptorName;
    private ServiceAuthorizationChain parentChain;
    private boolean chained = false;

    public ServiceAuthorizationChain() {
    }

    public ServiceAuthorizationChain(ServiceAuthorizationChain parentChain) {
        this.parentChain = parentChain;
    }

    public synchronized void initialize(PDPConfig config, String name, String id) throws InitializeException {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.init(config);
        for (int i = 0; this.interceptor != null && i < this.interceptor.length; ++i) {
            this.interceptor[i].initialize(config, this.interceptorName[i], id);
        }
    }

    public String[] getPolicyNames() {
        ArrayList<String> policies = new ArrayList<String>();
        if (this.parentChain != null) {
            String[] parentPolicies = this.parentChain.getPolicyNames();
            for (int policy = 0; parentPolicies != null && policy < parentPolicies.length; ++policy) {
                policies.add(parentPolicies[policy]);
            }
        }
        for (int i = 0; this.interceptor != null && i < this.interceptor.length; ++i) {
            if (!(this.interceptor[i] instanceof PDP)) continue;
            PDP pdp = (PDP)this.interceptor[i];
            String[] localPolicies = pdp.getPolicyNames();
            for (int policy = 0; localPolicies != null && policy < localPolicies.length; ++policy) {
                policies.add(localPolicies[policy]);
            }
        }
        return policies.toArray(new String[0]);
    }

    public Node getPolicy(Node policy) throws InvalidPolicyException {
        Element element = null;
        try {
            Node node;
            Document doc = XMLUtils.newDocument();
            element = doc.createElementNS("http://www.globus.org/namespaces/2004/04/security/authorization/sam", "sam:servicePolicies");
            doc.appendChild(element);
            if (this.parentChain != null && (node = this.parentChain.getPolicy(policy)) != null) {
                Node importedNode = doc.importNode(node, true);
                element.appendChild(importedNode);
            }
            for (int i = 0; this.interceptor != null && i < this.interceptor.length; ++i) {
                PDP pdp;
                Node node2;
                if (!(this.interceptor[i] instanceof PDP) || (node2 = (pdp = (PDP)this.interceptor[i]).getPolicy(policy)) == null) continue;
                Node importedNode = doc.importNode(node2, true);
                element.appendChild(importedNode);
            }
        }
        catch (Exception e) {
            throw new InvalidPolicyException(i18n.getMessage("getPolicy"), e);
        }
        return element;
    }

    public Node setPolicy(Node policy) throws InvalidPolicyException {
        Element element = null;
        try {
            Node node;
            Document doc = XMLUtils.newDocument();
            element = doc.createElementNS("http://www.globus.org/namespaces/2004/04/security/authorization/sam", "sam:servicePolicies");
            if (this.parentChain != null && (node = this.parentChain.setPolicy(policy)) != null) {
                Node importedNode = doc.importNode(node, true);
                element.appendChild(importedNode);
            }
            for (int i = 0; this.interceptor != null && i < this.interceptor.length; ++i) {
                PDP pdp;
                Node node2;
                if (!(this.interceptor[i] instanceof PDP) || (node2 = (pdp = (PDP)this.interceptor[i]).setPolicy(policy)) == null) continue;
                Node importedNode = doc.importNode(node2, true);
                element.appendChild(importedNode);
            }
        }
        catch (Exception e) {
            throw new InvalidPolicyException(i18n.getMessage("setPolicy"), e);
        }
        return element;
    }

    private boolean intercept(Subject peerSubject, MessageContext context, QName operation) throws AuthorizationException {
        boolean permitted = true;
        if (this.parentChain != null && this.parentChain.authorize(peerSubject, context, operation)) {
            return true;
        }
        for (int i = 0; this.interceptor != null && i < this.interceptor.length; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Interceptor " + this.interceptor[i].getClass().getName()));
            }
            if (this.interceptor[i] instanceof PDP) {
                if (((PDP)this.interceptor[i]).isPermitted(peerSubject, context, operation)) continue;
                permitted = false;
                break;
            }
            if (!(this.interceptor[i] instanceof PIP)) continue;
            ((PIP)this.interceptor[i]).collectAttributes(peerSubject, context, operation);
        }
        return permitted;
    }

    public void authorize(Subject peerSubject, MessageContext context, String service) throws AuthorizationException {
        this.authorize(peerSubject, context);
    }

    public boolean authorize(Subject peerSubject, MessageContext context) throws AuthorizationException {
        if (!this.initialized) {
            throw new AuthorizationException(i18n.getMessage("initialize"));
        }
        QName operation = null;
        try {
            operation = (QName)context.getProperty("org.globus.security.pdp.action");
            if (operation == null) {
                operation = AuthUtil.getOperationName((org.apache.axis.MessageContext)context);
            }
        }
        catch (AxisFault e) {
            operation = null;
        }
        catch (SecurityException e) {
            operation = null;
        }
        if (operation == null) {
            throw new AuthorizationException(i18n.getMessage("noTargetOperation"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Target operation is \"" + operation.toString() + "\". Called by subject \"" + AuthUtil.getIdentity(peerSubject) + "\""));
        }
        return this.authorize(peerSubject, context, operation);
    }

    public boolean authorize(Subject peerSubject, MessageContext context, QName operation) throws AuthorizationException {
        String peerIdentity = AuthUtil.getIdentity(peerSubject);
        try {
            if (this.intercept(peerSubject, context, operation)) {
                logger.info((Object)i18n.getMessage("authorized", new Object[]{peerIdentity, operation}));
                return true;
            }
            if (this.chained) {
                return false;
            }
            logger.warn((Object)i18n.getMessage("notAuthorized", new Object[]{peerIdentity, operation}));
        }
        catch (Exception e) {
            throw new AuthorizationException(i18n.getMessage("policyDecision"), e);
        }
        throw new AuthorizationException(i18n.getMessage("notAuthorized", new Object[]{peerIdentity, operation}));
    }

    public void setChained(boolean chained) {
        this.chained = chained;
    }

    public boolean isChained() {
        return this.chained;
    }

    private synchronized void init(PDPConfig config) throws InitializeException {
        InterceptorConfig[] interceptorConfig = config.getInterceptors();
        if (interceptorConfig == null) {
            throw new InitializeException(i18n.getMessage("noInterceptors"));
        }
        this.interceptor = new Interceptor[interceptorConfig.length];
        this.interceptorName = new String[interceptorConfig.length];
        try {
            for (int i = 0; i < interceptorConfig.length; ++i) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to load: " + interceptorConfig[i].getInterceptorClass()));
                }
                this.interceptor[i] = (Interceptor)(class$org$globus$wsrf$impl$security$authorization$ServiceAuthorizationChain == null ? ServiceAuthorizationChain.class$("org.globus.wsrf.impl.security.authorization.ServiceAuthorizationChain") : class$org$globus$wsrf$impl$security$authorization$ServiceAuthorizationChain).getClassLoader().loadClass(interceptorConfig[i].getInterceptorClass()).newInstance();
                this.interceptorName[i] = interceptorConfig[i].getName();
            }
        }
        catch (Exception e) {
            throw new InitializeException(i18n.getMessage("loadChain"), e);
        }
    }

    public void close() throws CloseException {
        for (int i = 0; i < this.interceptor.length; ++i) {
            if (this.interceptor[i] == null) continue;
            this.interceptor[i].close();
        }
    }
}

