/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.encoding;

import java.io.StringReader;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.encoding.DeserializationException;
import org.globus.wsrf.utils.Resources;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;

public class ObjectDeserializationContext
extends DeserializationContext {
    static Log logger = LogFactory.getLog((String)ObjectDeserializationContext.class.getName());
    static I18n i18n = I18n.getI18n((String)Resources.class.getName());
    private Deserializer topDeserializer = null;

    public ObjectDeserializationContext(MessageElement element) throws DeserializationException {
        this(element, null);
    }

    public ObjectDeserializationContext(MessageElement element, Class javaClass) throws DeserializationException {
        super(ContainerConfig.getContext(), new SOAPHandler());
        this.init(element.getType(), javaClass);
        String inputString = element.toString();
        logger.debug((Object)inputString);
        this.inputSource = new InputSource(new StringReader(inputString));
    }

    public ObjectDeserializationContext(Element element) throws DeserializationException {
        this(element, null);
    }

    public ObjectDeserializationContext(Element element, Class javaClass) throws DeserializationException {
        super(ContainerConfig.getContext(), new SOAPHandler());
        String typeAttr = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        QName type = null;
        if (typeAttr != null && typeAttr.length() > 0) {
            type = XMLUtils.getQNameFromString((String)typeAttr, (Node)element);
        }
        this.init(type, javaClass);
        String inputString = XMLUtils.ElementToString((Element)element);
        logger.debug((Object)inputString);
        this.inputSource = new InputSource(new StringReader(inputString));
    }

    public ObjectDeserializationContext(InputSource input, Class javaClass) throws DeserializationException {
        super(ContainerConfig.getContext(), new SOAPHandler());
        this.init(null, javaClass);
        this.inputSource = input;
    }

    private void setDeserializer(QName type, Class javaClass) throws DeserializationException {
        if (type == null && javaClass == null) {
            throw new DeserializationException(i18n.getMessage("typeOrClassRequired"));
        }
        if (type != null) {
            this.topDeserializer = this.getDeserializerForType(type);
        } else {
            QName defaultXMLType = this.getTypeMapping().getTypeQName(javaClass);
            this.topDeserializer = this.getDeserializer(javaClass, defaultXMLType);
        }
        if (this.topDeserializer == null) {
            this.topDeserializer = this.getDeserializerForClass(javaClass);
        }
    }

    private void init(QName type, Class javaClass) throws DeserializationException {
        this.msgContext.setEncodingStyle("");
        this.popElementHandler();
        this.setDeserializer(type, javaClass);
        if (this.topDeserializer == null) {
            String arg = type == null ? javaClass.getName() : type.toString();
            throw new DeserializationException(i18n.getMessage("noDeserializer", (Object)arg));
        }
        this.pushElementHandler((SOAPHandler)new EnvelopeHandler((SOAPHandler)this.topDeserializer));
    }

    public void setDocumentLocator(Locator locator) {
    }

    public Object getValue() {
        return this.topDeserializer == null ? null : this.topDeserializer.getValue();
    }

    public MessageElement getMessageElement() {
        if (this.topDeserializer == null || !(this.topDeserializer instanceof SOAPHandler)) {
            return null;
        }
        return ((SOAPHandler)this.topDeserializer).myElement;
    }

    public QName getQName() {
        MessageElement element = this.getMessageElement();
        return element == null ? null : element.getQName();
    }
}

