/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.resources.node;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.common.PlatformDescription;

public class Description {
    private String name;
    private String uptime;
    private GHNContext.Status status = null;
    private Type type = Type.Dynamic;
    private boolean securityEnabled;
    private Architecture architecture;
    private OperatingSystem os;
    private List<Processor> processors = new ArrayList<Processor>();
    private List<NetworkAdapter> adapters = new ArrayList<NetworkAdapter>();
    private Benchmark benchmark;
    private RuntimeEnvironment runtime;
    private Map<String, StorageDevice> storageDevices = new HashMap<String, StorageDevice>();
    private Map<String, StoragePartition> storagePartitions = new HashMap<String, StoragePartition>();
    private Map<String, FileSystem> localFS = new HashMap<String, FileSystem>();
    private Map<String, FileSystem> remoteFS = new HashMap<String, FileSystem>();
    private List<PlatformDescription> platforms = new ArrayList<PlatformDescription>();
    private Load load;
    private HistoricalLoad historicalLoad;
    private Memory memory;
    private Long LocalAvailableSpace;
    private Calendar lastUpdate;
    private Calendar activation;
    private String message;
    private SecurityData data;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(GHNContext.Status status, String ... message) {
        this.status = status;
        if (message != null && message.length > 0) {
            this.message = message[0];
        } else {
            message = null;
        }
    }

    public GHNContext.Status getStatus() {
        return this.status;
    }

    public void setStatusMessage(String message) {
        this.message = message;
    }

    public String getStatusMessage() {
        return this.message;
    }

    public String getUptime() {
        return this.uptime;
    }

    public void setUptime(String uptime) {
        this.uptime = uptime;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(Architecture architecture) {
        this.architecture = architecture;
    }

    public OperatingSystem getOS() {
        return this.os;
    }

    public void setOS(OperatingSystem os) {
        this.os = os;
    }

    public Benchmark getBenchmark() {
        return this.benchmark;
    }

    public void setBenchmark(Benchmark benchmark) {
        this.benchmark = benchmark;
    }

    public RuntimeEnvironment getRuntime() {
        return this.runtime;
    }

    public void setRuntime(RuntimeEnvironment runtime) {
        this.runtime = runtime;
    }

    public Load getLoad() {
        return this.load;
    }

    public void setLoad(Load load) {
        this.load = load;
    }

    public HistoricalLoad getHistoricalLoad() {
        return this.historicalLoad;
    }

    public void setHistoricalLoad(HistoricalLoad historicalLoad) {
        this.historicalLoad = historicalLoad;
    }

    public Memory getMemory() {
        return this.memory;
    }

    public void setMemory(Memory memory) {
        this.memory = memory;
    }

    public Long getLocalAvailableSpace() {
        return this.LocalAvailableSpace;
    }

    public void setLocalAvailableSpace(Long localAvailableSpace) {
        this.LocalAvailableSpace = localAvailableSpace;
    }

    public Calendar getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Calendar lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Calendar getActivationTime() {
        return this.activation;
    }

    public void setActivationTime(Calendar activation) {
        this.activation = activation;
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public List<NetworkAdapter> getNetworkAdapters() {
        return this.adapters;
    }

    public void addStorageDevice(StorageDevice sd) {
        this.storageDevices.put(sd.getName(), sd);
    }

    public void removeStorageDevice(StorageDevice sd) {
        this.storageDevices.remove(sd);
    }

    public StorageDevice getStorageDevice(String name) {
        return this.storageDevices.get(name);
    }

    public Collection<StorageDevice> getStorageDevices() {
        return Collections.unmodifiableCollection(this.storageDevices.values());
    }

    public void addLocalFileSystem(FileSystem fs) {
        this.localFS.put(fs.getName(), fs);
    }

    public void removeLocalFileSystem(FileSystem fs) {
        this.localFS.remove(fs);
    }

    public FileSystem getLocalFileSystem(String name) {
        return this.localFS.get(name);
    }

    public Collection<FileSystem> getLocalFileSystems() {
        return Collections.unmodifiableCollection(this.localFS.values());
    }

    public void addRemoteFileSystem(FileSystem fs) {
        this.remoteFS.put(fs.getName(), fs);
    }

    public void removeRemoteFileSystem(FileSystem fs) {
        this.remoteFS.remove(fs);
    }

    public FileSystem getRemoteFileSystem(String name) {
        return this.remoteFS.get(name);
    }

    public Collection<FileSystem> getRemoteFileSystems() {
        return Collections.unmodifiableCollection(this.remoteFS.values());
    }

    public void addStoragePartition(StoragePartition sp) {
        this.storagePartitions.put(sp.getName(), sp);
    }

    public void removeStoragePartition(StoragePartition sp) {
        this.storagePartitions.remove(sp);
    }

    public Collection<StoragePartition> getStoragePartitions() {
        return Collections.unmodifiableCollection(this.storagePartitions.values());
    }

    public StoragePartition getStoragePartition(String name) {
        return this.storagePartitions.get(name);
    }

    public void addSecurityData(SecurityData data) {
        this.data = data;
    }

    public SecurityData getSecurityData() {
        return this.data;
    }

    public List<PlatformDescription> getAvailablePlatforms() {
        return this.platforms;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Description other = (Description)obj;
        if (this.adapters == null ? other.adapters != null : !((Object)this.adapters).equals(other.adapters)) {
            return false;
        }
        if (this.processors == null ? other.processors != null : !((Object)this.processors).equals(other.processors)) {
            return false;
        }
        if (this.uptime == null ? other.uptime != null : !this.uptime.equals(other.uptime)) {
            return false;
        }
        if (this.securityEnabled != other.securityEnabled) {
            return false;
        }
        if (this.architecture == null ? other.architecture != null : !this.architecture.equals(other.architecture)) {
            return false;
        }
        if (this.os == null ? other.os != null : !this.os.equals(other.os)) {
            return false;
        }
        if (this.benchmark == null ? other.benchmark != null : !this.benchmark.equals(other.benchmark)) {
            return false;
        }
        if (this.storageDevices == null ? other.storageDevices != null : !((Object)this.storageDevices).equals(other.storageDevices)) {
            return false;
        }
        if (this.storagePartitions == null ? other.storagePartitions != null : !((Object)this.storagePartitions).equals(other.storagePartitions)) {
            return false;
        }
        if (this.localFS == null ? other.localFS != null : !((Object)this.localFS).equals(other.localFS)) {
            return false;
        }
        if (this.remoteFS == null ? other.remoteFS != null : !((Object)this.remoteFS).equals(other.remoteFS)) {
            return false;
        }
        if (this.load == null ? other.load != null : !this.load.equals(other.load)) {
            return false;
        }
        if (this.historicalLoad == null ? other.historicalLoad != null : !this.historicalLoad.equals(other.historicalLoad)) {
            return false;
        }
        if (this.memory == null ? other.memory != null : !this.memory.equals(other.memory)) {
            return false;
        }
        if (this.LocalAvailableSpace == null ? other.LocalAvailableSpace != null : !this.LocalAvailableSpace.equals(other.LocalAvailableSpace)) {
            return false;
        }
        if (this.lastUpdate == null ? other.lastUpdate != null : !this.lastUpdate.equals(other.lastUpdate)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.runtime == null ? other.runtime != null : !this.runtime.equals(other.runtime)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    public static class Memory {
        private Long size;
        private Long virtualSize;
        private Long available;
        private Long virtualAvailable;

        public Long getSize() {
            return this.size;
        }

        public void setSize(Long size) {
            this.size = size;
        }

        public Long getVirtualSize() {
            return this.virtualSize;
        }

        public void setVirtualSize(Long virtualSize) {
            this.virtualSize = virtualSize;
        }

        public Long getAvailable() {
            return this.available;
        }

        public void setAvailable(Long available) {
            this.available = available;
        }

        public Long getVirtualAvailable() {
            return this.virtualAvailable;
        }

        public void setVirtualAvailable(Long virtualAvailable) {
            this.virtualAvailable = virtualAvailable;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Memory other = (Memory)obj;
            if (this.virtualSize == null ? other.virtualSize != null : !this.virtualSize.equals(other.virtualSize)) {
                return false;
            }
            if (this.available == null ? other.available != null : !this.available.equals(other.available)) {
                return false;
            }
            if (this.virtualAvailable == null ? other.virtualAvailable != null : !this.virtualAvailable.equals(other.virtualAvailable)) {
                return false;
            }
            return !(this.size == null ? other.size != null : !this.size.equals(other.size));
        }
    }

    public static class HistoricalLoad {
        private Double last1Hour;
        private Double last1Day;
        private Double last1Week;

        public Double getLast1Hour() {
            return this.last1Hour;
        }

        public void setLast1Hour(Double last1Hour) {
            this.last1Hour = last1Hour;
        }

        public Double getLast1Day() {
            return this.last1Day;
        }

        public void setLast1Day(Double last1Day) {
            this.last1Day = last1Day;
        }

        public Double getLast1Week() {
            return this.last1Week;
        }

        public void setLast1Week(Double last1Week) {
            this.last1Week = last1Week;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HistoricalLoad other = (HistoricalLoad)obj;
            if (this.last1Hour == null ? other.last1Hour != null : !this.last1Hour.equals(other.last1Hour)) {
                return false;
            }
            if (this.last1Day == null ? other.last1Day != null : !this.last1Day.equals(other.last1Day)) {
                return false;
            }
            return !(this.last1Week == null ? other.last1Week != null : !this.last1Week.equals(other.last1Week));
        }
    }

    public static class SecurityData {
        private Calendar credentialsDate;
        private String credentialsDistinguishedName;
        private String ca;

        public String getCA() {
            return this.ca;
        }

        public void setCA(String ca) {
            this.ca = ca;
        }

        public Calendar getCredentianlsExpireOn() {
            return this.credentialsDate;
        }

        public void setCredentianlsExpireOn(Calendar credentialsDate) {
            this.credentialsDate = credentialsDate;
        }

        public String getCredentialsDistinguishedName() {
            return this.credentialsDistinguishedName;
        }

        public void setCredentialsDistinguishedName(String credentialsDistinguishedName) {
            this.credentialsDistinguishedName = credentialsDistinguishedName;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SecurityData other = (SecurityData)obj;
            if (this.credentialsDate == null ? other.credentialsDate != null : !this.credentialsDate.equals(other.credentialsDate)) {
                return false;
            }
            if (this.credentialsDistinguishedName == null ? other.credentialsDistinguishedName != null : !this.credentialsDistinguishedName.equals(other.credentialsDistinguishedName)) {
                return false;
            }
            return !(this.ca == null ? other.ca != null : !this.ca.equals(other.ca));
        }
    }

    public static class Load {
        private Double last1min;
        private Double last5min;
        private Double last15min;

        public Double getLast1min() {
            return this.last1min;
        }

        public void setLast1min(Double last1min) {
            this.last1min = last1min;
        }

        public Double getLast5min() {
            return this.last5min;
        }

        public void setLast5min(Double last5min) {
            this.last5min = last5min;
        }

        public Double getLast15min() {
            return this.last15min;
        }

        public void setLast15min(Double last15min) {
            this.last15min = last15min;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Load other = (Load)obj;
            if (this.last1min == null ? other.last1min != null : !this.last1min.equals(other.last1min)) {
                return false;
            }
            if (this.last5min == null ? other.last5min != null : !this.last5min.equals(other.last5min)) {
                return false;
            }
            return !(this.last15min == null ? other.last15min != null : !this.last15min.equals(other.last15min));
        }
    }

    public static class FileSystem {
        private String name;
        private String root;
        private String type;
        private long size;
        private boolean readOnly;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRoot() {
            return this.root;
        }

        public void setRoot(String root) {
            this.root = root;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileSystem other = (FileSystem)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            if (this.size != other.size) {
                return false;
            }
            if (this.readOnly != other.readOnly) {
                return false;
            }
            return !(this.root == null ? other.root != null : !this.root.equals(other.root));
        }
    }

    public static class StoragePartition {
        private String name;
        private String size;
        private long readRate;
        private long writeRate;
        private Map<String, FileSystem> fileSystems = new HashMap<String, FileSystem>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSize() {
            return this.size;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public long getReadRate() {
            return this.readRate;
        }

        public void setReadRate(long readRate) {
            this.readRate = readRate;
        }

        public long getWriteRate() {
            return this.writeRate;
        }

        public void setWriteRate(long writeRate) {
            this.writeRate = writeRate;
        }

        public Map<String, FileSystem> getFileSystems() {
            return this.fileSystems;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StoragePartition other = (StoragePartition)obj;
            if (this.fileSystems == null ? other.fileSystems != null : !((Object)this.fileSystems).equals(other.fileSystems)) {
                return false;
            }
            if (this.readRate != other.readRate) {
                return false;
            }
            if (this.writeRate != other.writeRate) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.size == null ? other.size != null : !this.size.equals(other.size));
        }
    }

    public static class StorageDevice {
        private String name;
        private String type;
        private long transferRate;
        private long size;
        private Map<String, StoragePartition> partitions = new HashMap<String, StoragePartition>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public long getTransferRate() {
            return this.transferRate;
        }

        public void setTransferRate(long transferRate) {
            this.transferRate = transferRate;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public Map<String, StoragePartition> getPartitions() {
            return this.partitions;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StorageDevice other = (StorageDevice)obj;
            if (this.partitions == null ? other.partitions != null : !((Object)this.partitions).equals(other.partitions)) {
                return false;
            }
            if (this.transferRate != other.transferRate) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return this.size == other.size;
        }
    }

    public static class RuntimeEnvironment {
        private List<Variable> variables = new ArrayList<Variable>();

        public List<Variable> getVariables() {
            return this.variables;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RuntimeEnvironment other = (RuntimeEnvironment)obj;
            return !(this.variables == null ? other.variables != null : !((Object)this.variables).equals(other.variables));
        }

        public static class Variable {
            private String Key;
            private String Value;

            public String getKey() {
                return this.Key;
            }

            public void setKey(String key) {
                this.Key = key;
            }

            public String getValue() {
                return this.Value;
            }

            public void setValue(String value) {
                this.Value = value;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Variable other = (Variable)obj;
                if (this.Value == null ? other.Value != null : !this.Value.equals(other.Value)) {
                    return false;
                }
                return !(this.Key == null ? other.Key != null : !this.Key.equals(other.Key));
            }
        }
    }

    public static class Benchmark {
        private long SI00;
        private long SF00;

        public long getSI00() {
            return this.SI00;
        }

        public void setSI00(long si00) {
            this.SI00 = si00;
        }

        public long getSF00() {
            return this.SF00;
        }

        public void setSF00(long sf00) {
            this.SF00 = sf00;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Benchmark other = (Benchmark)obj;
            if (this.SI00 != other.SI00) {
                return false;
            }
            return this.SF00 == other.SF00;
        }
    }

    public static class NetworkAdapter {
        private String inboundIP;
        private String outboundIP;
        private String name;
        private String IPaddress;
        private long MTU;

        public String getInboundIP() {
            return this.inboundIP;
        }

        public void setInboundIP(String inboundIP) {
            this.inboundIP = inboundIP;
        }

        public String getOutboundIP() {
            return this.outboundIP;
        }

        public void setOutboundIP(String outboundIP) {
            this.outboundIP = outboundIP;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getIPAddress() {
            return this.IPaddress;
        }

        public void setIPAddress(String paddress) {
            this.IPaddress = paddress;
        }

        public long getMTU() {
            return this.MTU;
        }

        public void setMTU(long mtu) {
            this.MTU = mtu;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NetworkAdapter other = (NetworkAdapter)obj;
            if (this.inboundIP == null ? other.inboundIP != null : !this.inboundIP.equals(other.inboundIP)) {
                return false;
            }
            if (this.outboundIP == null ? other.outboundIP != null : !this.outboundIP.equals(other.outboundIP)) {
                return false;
            }
            if (this.IPaddress == null ? other.IPaddress != null : !this.IPaddress.equals(other.IPaddress)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.MTU == other.MTU;
        }
    }

    public static class Processor {
        private String vendor;
        private String model;
        private String modelName;
        private String family;
        private long cacheL1;
        private long cacheL1I;
        private long cacheL1D;
        private long cacheL2;
        private double clockSpeedMHZ;
        private double bogomips;

        public double getClockSpeedMHZ() {
            return this.clockSpeedMHZ;
        }

        public void setClockSpeedMHZ(double clockSpeedMHZ) {
            this.clockSpeedMHZ = clockSpeedMHZ;
        }

        public long getCacheL1() {
            return this.cacheL1;
        }

        public void setCacheL1(long chacheL1) {
            this.cacheL1 = chacheL1;
        }

        public long getCacheL1I() {
            return this.cacheL1I;
        }

        public void setCacheL1I(long cacheL1I) {
            this.cacheL1I = cacheL1I;
        }

        public long getCacheL1D() {
            return this.cacheL1D;
        }

        public void setCacheL1D(long chacheL1D) {
            this.cacheL1D = chacheL1D;
        }

        public long getCacheL2() {
            return this.cacheL2;
        }

        public void setCacheL2(long cacheL2) {
            this.cacheL2 = cacheL2;
        }

        public double getBogomips() {
            return this.bogomips;
        }

        public void setBogomips(double bogomips) {
            this.bogomips = bogomips;
        }

        public String getVendor() {
            return this.vendor;
        }

        public void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public String getModelName() {
            return this.modelName;
        }

        public void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public String getFamily() {
            return this.family;
        }

        public void setFamily(String family) {
            this.family = family;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Processor other = (Processor)obj;
            if (this.clockSpeedMHZ != other.clockSpeedMHZ) {
                return false;
            }
            if (this.cacheL1 != other.cacheL1) {
                return false;
            }
            if (this.cacheL1I != other.cacheL1I) {
                return false;
            }
            if (this.cacheL1D != other.cacheL1D) {
                return false;
            }
            if (this.cacheL2 != other.cacheL2) {
                return false;
            }
            if (this.bogomips != other.bogomips) {
                return false;
            }
            if (this.vendor == null ? other.vendor != null : !this.vendor.equals(other.vendor)) {
                return false;
            }
            if (this.modelName == null ? other.modelName != null : !this.modelName.equals(other.modelName)) {
                return false;
            }
            if (this.family == null ? other.family != null : !this.family.equals(other.family)) {
                return false;
            }
            return !(this.model == null ? other.model != null : !this.model.equals(other.model));
        }
    }

    public static class OperatingSystem {
        private String name;
        private String release;
        private String version;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRelease() {
            return this.release;
        }

        public void setRelease(String release) {
            this.release = release;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OperatingSystem other = (OperatingSystem)obj;
            if (this.release == null ? other.release != null : !this.release.equals(other.release)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }

    public static class Architecture {
        private String platformType;
        private long SMPSize;
        private long SMTSize;

        public String getPlatformType() {
            return this.platformType;
        }

        public void setPlatformType(String platformType) {
            this.platformType = platformType;
        }

        public long getSMPSize() {
            return this.SMPSize;
        }

        public void setSMPSize(long size) {
            this.SMPSize = size;
        }

        public long getSMTSize() {
            return this.SMTSize;
        }

        public void setSMTSize(long size) {
            this.SMTSize = size;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Architecture other = (Architecture)obj;
            if (this.platformType == null ? other.platformType != null : !this.platformType.equals(other.platformType)) {
                return false;
            }
            if (this.SMPSize != other.SMPSize) {
                return false;
            }
            return this.SMTSize == other.SMTSize;
        }
    }

    public static enum Type {
        Static,
        Dynamic,
        Selfcleaning;

    }
}

