/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.test;

import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.container.ServiceContainer;

public class TestContainer {
    protected ServiceContainer server = null;
    protected Map properties = new HashMap();
    protected String baseURL;
    protected String webServerURL = null;
    protected static final String WEB_SERVER_URL = "web.server.url";
    private boolean collocated;
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$test$TestContainer == null ? (class$org$globus$wsrf$test$TestContainer = TestContainer.class$("org.globus.wsrf.test.TestContainer")) : class$org$globus$wsrf$test$TestContainer).getName());
    static /* synthetic */ Class class$org$globus$wsrf$test$TestContainer;

    public TestContainer() {
        this.properties.put("container.mainThread", Boolean.FALSE);
    }

    public TestContainer(String containerConfigFile) {
        this();
        this.properties.put("container.server.config", containerConfigFile);
    }

    public boolean isCollocated() {
        return this.collocated;
    }

    protected String getPropertySeverUrl() {
        return System.getProperty(WEB_SERVER_URL);
    }

    public void start() throws Exception {
        this.webServerURL = this.getPropertySeverUrl();
        if (this.webServerURL == null) {
            if (this.server == null) {
                this.collocated = true;
                this.server = ServiceContainer.createContainer((Map)this.properties);
                logger.debug((Object)("Starting standalone container at:" + this.server.getURLString()));
            }
            this.baseURL = this.server.getURLString();
        } else {
            this.collocated = false;
            this.baseURL = this.getIP(this.webServerURL);
            logger.debug((Object)("Starting test using server container at:" + this.baseURL));
        }
    }

    public void stop() throws Exception {
        if (this.webServerURL == null && this.server != null) {
            this.server.stop();
        }
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public int getPort() {
        int port = 0;
        try {
            port = new URL(this.baseURL).getPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    public String getHost() {
        try {
            return new URL(this.baseURL).getHost();
        }
        catch (Exception e) {
            return "localhost";
        }
    }

    public String getIP(String urlString) throws Exception {
        URL url = new URL(urlString);
        String host = url.getHost();
        String ipHost = null;
        if (host.equals("localhost") || host.equals("127.0.0.1")) {
            ipHost = InetAddress.getLocalHost().getHostAddress();
        } else {
            try {
                ipHost = InetAddress.getByName(host).getHostAddress();
            }
            catch (Exception e) {
                ipHost = host;
            }
        }
        url = new URL(url.getProtocol(), ipHost, url.getPort(), url.getPath());
        return url.toExternalForm();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

