/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.LockOwner;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;

public class IndirectMessageReference
implements QueueMessageReference {
    private LockOwner lockOwner;
    private boolean dropped;
    private boolean acked;
    private final Message message;

    public IndirectMessageReference(Message message) {
        this.message = message;
        message.getMessageId();
        message.getGroupID();
        message.getGroupSequence();
    }

    public Message getMessageHardRef() {
        return this.message;
    }

    public int getReferenceCount() {
        return this.message.getReferenceCount();
    }

    public int incrementReferenceCount() {
        return this.message.incrementReferenceCount();
    }

    public int decrementReferenceCount() {
        return this.message.decrementReferenceCount();
    }

    public Message getMessage() {
        return this.message;
    }

    public String toString() {
        return "Message " + this.message.getMessageId() + " dropped=" + this.dropped + " locked=" + (this.lockOwner != null);
    }

    public void incrementRedeliveryCounter() {
        this.message.incrementRedeliveryCounter();
    }

    public synchronized boolean isDropped() {
        return this.dropped;
    }

    public synchronized void drop() {
        this.dropped = true;
        this.lockOwner = null;
        this.message.decrementReferenceCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(LockOwner subscription) {
        IndirectMessageReference indirectMessageReference = this;
        synchronized (indirectMessageReference) {
            if (this.dropped || this.lockOwner != null) {
                return false;
            }
            this.lockOwner = subscription;
            return true;
        }
    }

    public synchronized boolean unlock() {
        boolean result = this.lockOwner != null;
        this.lockOwner = null;
        return result;
    }

    public synchronized LockOwner getLockOwner() {
        return this.lockOwner;
    }

    public int getRedeliveryCounter() {
        return this.message.getRedeliveryCounter();
    }

    public MessageId getMessageId() {
        return this.message.getMessageId();
    }

    public Destination getRegionDestination() {
        return this.message.getRegionDestination();
    }

    public boolean isPersistent() {
        return this.message.isPersistent();
    }

    public synchronized boolean isLocked() {
        return this.lockOwner != null;
    }

    public synchronized boolean isAcked() {
        return this.acked;
    }

    public synchronized void setAcked(boolean b) {
        this.acked = b;
    }

    public String getGroupID() {
        return this.message.getGroupID();
    }

    public int getGroupSequence() {
        return this.message.getGroupSequence();
    }

    public ConsumerId getTargetConsumerId() {
        return this.message.getTargetConsumerId();
    }

    public long getExpiration() {
        return this.message.getExpiration();
    }

    public boolean isExpired() {
        return this.message.isExpired();
    }

    public synchronized int getSize() {
        return this.message.getSize();
    }

    public boolean isAdvisory() {
        return this.message.isAdvisory();
    }
}

