/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.reader.decorators.keepalive;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderInvalidArgumentException;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class KeepAliveHandler<T extends Record>
implements Runnable {
    private static Logger logger = Logger.getLogger(KeepAliveHandler.class.getName());
    private IRecordReader<T> reader = null;
    private LinkedList<T> queue = new LinkedList();
    private long keepAliveFrequency = 0L;
    private TimeUnit keepAliveFrequencyUnit = null;
    private long inactivityTimeout = 0L;
    private TimeUnit inactivityTimeUnit = null;
    private Integer inactivityRecordThreshold = null;
    private Integer sizeUponPreviousRetrieval = 0;
    private Object synchQueue = new Object();
    private Object synch = null;

    public KeepAliveHandler(IRecordReader<T> reader, long keepAliveFrequency, TimeUnit keepAliveFrequencyUnit, Object synch) throws GRS2ReaderInvalidArgumentException {
        if (reader == null) {
            throw new GRS2ReaderInvalidArgumentException("Invalid reader reference");
        }
        if (keepAliveFrequency < 1L) {
            throw new GRS2ReaderInvalidArgumentException("Keep-alive frequency should be positive");
        }
        if (synch == null) {
            throw new GRS2ReaderInvalidArgumentException("Invalid synchronization object reference");
        }
        this.reader = reader;
        this.keepAliveFrequency = keepAliveFrequency;
        this.keepAliveFrequencyUnit = keepAliveFrequencyUnit;
        this.synch = synch;
    }

    public KeepAliveHandler(IRecordReader<T> reader, long keepAliveFrequency, TimeUnit keepAliveFrequencyUnit, long inactivityTimeout, TimeUnit inactivityTimeUnit, Object synch) throws GRS2ReaderInvalidArgumentException {
        this(reader, keepAliveFrequency, keepAliveFrequencyUnit, synch);
        if (inactivityTimeout < 1L) {
            throw new GRS2ReaderInvalidArgumentException("Inactivity timeout should be positive");
        }
        this.inactivityTimeout = inactivityTimeout;
        this.inactivityTimeUnit = inactivityTimeUnit;
        this.inactivityRecordThreshold = (int)(inactivityTimeUnit.toMillis(inactivityTimeout) / keepAliveFrequencyUnit.toMillis(keepAliveFrequency));
        logger.log(Level.FINE, "Computed inactivity record threshold to " + this.inactivityRecordThreshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableRecords() {
        Object object = this.synchQueue;
        synchronized (object) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        Object object = this.synchQueue;
        synchronized (object) {
            Record rec = (Record)this.queue.pollFirst();
            if (this.inactivityRecordThreshold != null) {
                this.sizeUponPreviousRetrieval = this.queue.size();
                logger.log(Level.FINE, "Queue size on past retrieval is " + this.sizeUponPreviousRetrieval);
            }
            rec.show();
            return (T)rec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.synchQueue;
        synchronized (object) {
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                try {
                    this.keepAliveFrequencyUnit.sleep(this.keepAliveFrequency);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.reader.getStatus() != IBuffer.Status.Open) {
                    return;
                }
                Object e = this.synch;
                synchronized (e) {
                    T record = this.reader.get();
                    if (record != null) {
                        Object object = this.synchQueue;
                        synchronized (object) {
                            ((Record)record).hide();
                            this.queue.add(record);
                        }
                    }
                    if (this.inactivityRecordThreshold != null && this.queue.size() > this.sizeUponPreviousRetrieval + this.inactivityRecordThreshold) {
                        logger.log(Level.FINE, "Closing keep-alive reader due to inactivity");
                        this.reader.close();
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Keep alive handler halted", e);
        }
    }
}

