/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authorization;

import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityFault;
import org.globus.wsrf.security.authorization.PDPConstants;

public class TrustedTargetHandler
extends GenericHandler {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authorization.errors", (ClassLoader)TrustedTargetHandler.class.getClassLoader());
    static Log logger = LogFactory.getLog((String)TrustedTargetHandler.class.getName());

    public boolean handleRequest(MessageContext msgContext) {
        SecurityContext secContext = (SecurityContext)msgContext.getProperty("org.globus.security.secureconv.context");
        HashMap allowedTargets = (HashMap)msgContext.getProperty("org.globus.security.target.trusted");
        if (allowedTargets == null) {
            return true;
        }
        if (secContext != null) {
            String target = null;
            try {
                target = ((Object)secContext.getContext().getTargName()).toString();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Source name: " + ((Object)secContext.getContext().getSrcName()).toString()));
                    logger.debug((Object)("Target name: " + target));
                }
            }
            catch (Exception e) {
                throw WSSecurityFault.makeFault(e);
            }
            if (allowedTargets.get(target) == null) {
                Detail detail = null;
                try {
                    SOAPFactory factory = SOAPFactory.newInstance();
                    detail = factory.createDetail();
                    Name detailName = factory.createName("target", null, "http://www.globus.org/pdp");
                    DetailEntry entry = detail.addDetailEntry(detailName);
                    entry.addTextNode(i18n.getMessage("target", (Object)target));
                }
                catch (SOAPException ee) {
                    // empty catch block
                }
                throw new SOAPFaultException(PDPConstants.TARGET_NOT_ALLOWED_ERROR, i18n.getMessage("trustTarget"), null, detail);
            }
        }
        return true;
    }

    public QName[] getHeaders() {
        return null;
    }
}

