/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.message.MessageElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.globus.wsrf.utils.Resources;
import org.w3c.dom.Element;

public abstract class BaseResourceProperty
implements ResourceProperty {
    private static Log logger = LogFactory.getLog((String)BaseResourceProperty.class.getName());
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());
    protected ResourcePropertyMetaData metaData;

    public BaseResourceProperty(QName name) {
        this(new SimpleResourcePropertyMetaData(name));
    }

    public BaseResourceProperty(ResourcePropertyMetaData metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", (Object)"metaData"));
        }
        this.metaData = metaData;
    }

    protected void setMetaData(ResourcePropertyMetaData metaData) {
        this.metaData = metaData;
    }

    public ResourcePropertyMetaData getMetaData() {
        return this.metaData;
    }

    protected Object convert(Object value) {
        if (value == null) {
            return null;
        }
        Class type = this.getMetaData().getType();
        if (type == null || type == Object.class) {
            return value;
        }
        try {
            if (type.isPrimitive()) {
                return this.convertPrimitive(type, value);
            }
            return this.convertObject(type, value);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = i18n.getMessage("failedToConvert", (Object)e.getMessage());
            logger.debug((Object)msg, (Throwable)e);
            throw new IllegalArgumentException(msg);
        }
    }

    protected Object convertObject(Class type, Object value) throws Exception {
        QName name = this.getMetaData().getName();
        return BaseResourceProperty.convert(value, type, name);
    }

    protected Object convertPrimitive(Class type, Object value) throws Exception {
        QName name = this.getMetaData().getName();
        if (type == Boolean.TYPE) {
            return BaseResourceProperty.convert(value, Boolean.class, name);
        }
        if (type == Character.TYPE) {
            return BaseResourceProperty.convert(value, Character.class, name);
        }
        if (type == Byte.TYPE) {
            return BaseResourceProperty.convert(value, Byte.class, name);
        }
        if (type == Short.TYPE) {
            return BaseResourceProperty.convert(value, Short.class, name);
        }
        if (type == Integer.TYPE) {
            return BaseResourceProperty.convert(value, Integer.class, name);
        }
        if (type == Long.TYPE) {
            return BaseResourceProperty.convert(value, Long.class, name);
        }
        if (type == Float.TYPE) {
            return BaseResourceProperty.convert(value, Float.class, name);
        }
        if (type == Double.TYPE) {
            return BaseResourceProperty.convert(value, Double.class, name);
        }
        throw new IllegalArgumentException(i18n.getMessage("cantConvertType", new Object[]{value.getClass(), type}));
    }

    private static Object convert(Object value, Class type, QName name) throws Exception {
        if (type.isAssignableFrom(value.getClass())) {
            if (value instanceof MessageElement && Element.class.equals(type)) {
                return ((MessageElement)value).getAsDOM();
            }
            return value;
        }
        if (value instanceof SOAPElement) {
            return ObjectDeserializer.toObject((SOAPElement)value, type);
        }
        if (value instanceof Element) {
            if (SOAPElement.class.equals(type)) {
                return new MessageElement((Element)value);
            }
            return ObjectDeserializer.toObject((Element)value, type);
        }
        if (type.equals(SOAPElement.class)) {
            return ObjectSerializer.toSOAPElement(value, name);
        }
        if (type.equals(Element.class)) {
            return ObjectSerializer.toElement(value, name);
        }
        throw new IllegalArgumentException(i18n.getMessage("cantConvertType", new Object[]{value.getClass(), type}));
    }
}

