/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.crypto;

import COM.claymoresystems.crypto.DHPublicKey;
import COM.claymoresystems.ptls.LoadProviders;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.SecureRandom;

public abstract class DHPrivateKey
implements PrivateKey {
    protected BigInteger X;
    protected BigInteger Y;
    protected BigInteger g;
    protected BigInteger p;

    public abstract void initPrivateKey(BigInteger var1, BigInteger var2, SecureRandom var3);

    public abstract void initPrivateKey(SecureRandom var1, int var2, boolean var3);

    public abstract byte[] keyAgree(DHPublicKey var1, boolean var2);

    public static DHPrivateKey getInstance() {
        String clazz = LoadProviders.haveGoNativeProvider() ? "COM.claymoresystems.gnp.OSDHPrivateKey" : "COM.claymoresystems.ptls.SSLDHPrivateKey";
        try {
            Class<?> cl = Class.forName(clazz);
            return (DHPrivateKey)cl.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalError("Couldn't find DH class" + clazz);
        }
    }

    protected byte[] toBytes(BigInteger num) {
        byte[] tmp = num.toByteArray();
        if (tmp[0] == 0) {
            byte[] trim = new byte[tmp.length - 1];
            System.arraycopy(tmp, 1, trim, 0, tmp.length - 1);
            return trim;
        }
        return tmp;
    }

    public BigInteger getX() {
        return this.X;
    }

    public BigInteger getY() {
        return this.Y;
    }

    public byte[] getYBytes() {
        return this.toBytes(this.Y);
    }

    public BigInteger getg() {
        return this.g;
    }

    public byte[] getgBytes() {
        return this.toBytes(this.g);
    }

    public BigInteger getp() {
        return this.p;
    }

    public byte[] getpBytes() {
        return this.toBytes(this.p);
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        return null;
    }

    public String getAlgorithm() {
        return "DH";
    }
}

