/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class BasicConstraints
implements DEREncodable {
    DERBoolean cA = new DERBoolean(false);
    DERInteger pathLenConstraint = null;

    public static BasicConstraints getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return BasicConstraints.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static BasicConstraints getInstance(Object object) {
        if (object == null || object instanceof BasicConstraints) {
            return (BasicConstraints)object;
        }
        if (object instanceof ASN1Sequence) {
            return new BasicConstraints((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public BasicConstraints(ASN1Sequence aSN1Sequence) {
        this.cA = (DERBoolean)aSN1Sequence.getObjectAt(0);
        if (aSN1Sequence.size() > 1) {
            this.pathLenConstraint = (DERInteger)aSN1Sequence.getObjectAt(1);
        }
    }

    public BasicConstraints(boolean bl, int n) {
        this.cA = new DERBoolean(bl);
        this.pathLenConstraint = new DERInteger(n);
    }

    public BasicConstraints(boolean bl) {
        this.cA = new DERBoolean(bl);
        this.pathLenConstraint = null;
    }

    public boolean isCA() {
        return this.cA.isTrue();
    }

    public BigInteger getPathLenConstraint() {
        if (this.pathLenConstraint != null) {
            return this.pathLenConstraint.getValue();
        }
        return null;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.cA);
        if (this.pathLenConstraint != null) {
            aSN1EncodableVector.add(this.pathLenConstraint);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        return "BasicConstraints: isCa(" + this.isCA() + "), pathLenConstraint = " + this.pathLenConstraint.getValue();
    }
}

