/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.resources;

import java.util.List;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.ServiceMap;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.local.GCUBELocalPublisher;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryClient;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstance;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstanceGroup;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryLookup;
import org.gcube.common.informationsystem.publisher.impl.resources.CreateResourceHandler;
import org.gcube.common.informationsystem.publisher.impl.resources.RemoveResourceHandler;
import org.gcube.common.informationsystem.publisher.impl.resources.UpdateResourceHandler;
import org.gcube.informationsystem.registry.stubs.RegistryFactoryPortType;

public final class RegistryResourcePublisher {
    protected static final GCUBELog logger = new GCUBELog(RegistryResourcePublisher.class);
    protected RegistryFactoryPortType registryFactoryPortType;
    private GCUBEScope scope;
    protected List<EndpointReferenceType> ICEprs;
    protected ISRegistryClient registryClient = ISRegistryClient.getISRegistryClient();

    public RegistryResourcePublisher(GCUBEScope scope) throws Exception {
        this.scope = scope;
    }

    public void create(GCUBEResource profile) throws Exception {
        if (this.useLocalEventsForResource(profile.getType())) {
            GCUBELocalPublisher.getManager().notifyResourceRegistered(profile, this.scope);
        } else {
            logger.trace((Object)("Trying to publish resource with ID=" + profile.getID() + " in scope " + this.scope));
            CreateResourceHandler handler = new CreateResourceHandler(this.scope, this.registryClient, profile);
            handler.execute();
        }
    }

    public void remove(String ID, String type) throws Exception {
        if (this.useLocalEventsForResource(type)) {
            GCUBELocalPublisher.getManager().notifyResourceRemoved(ID, type, this.scope);
        } else {
            logger.trace((Object)("Trying to unpublish resource with ID=" + ID + " in scope " + this.scope));
            RemoveResourceHandler handler = new RemoveResourceHandler(this.scope, this.registryClient, ID, type);
            handler.execute();
        }
    }

    public void update(GCUBEResource profile) throws Exception {
        if (this.useLocalEventsForResource(profile.getType())) {
            GCUBELocalPublisher.getManager().notifyResourceRegistered(profile, this.scope);
        } else {
            logger.trace((Object)("Trying to update resource with ID=" + profile.getID() + " in scope " + this.scope));
            UpdateResourceHandler handler = new UpdateResourceHandler(this.scope, this.registryClient, profile);
            handler.execute();
        }
    }

    private boolean useLocalEventsForResource(String type) throws ISRegistryLookup.NoRegistryAvailableException {
        try {
            Set eprs = this.scope.getServiceMap().getEndpoints((Object)ServiceMap.ServiceType.ISRegistry);
            if (eprs != null && !eprs.isEmpty()) {
                logger.trace((Object)"Configured ISRegistry instances detected");
                for (EndpointReferenceType epr : eprs) {
                    logger.trace((Object)("Checking local configuration for " + epr.getAddress().toString()));
                    if (!epr.getAddress().toString().contains(GHNContext.getContext().getPublishedHostnameAndPort())) continue;
                    logger.trace((Object)"Local ISRegistry instance detected");
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while detecting local ISRegistry instances", (Throwable)e);
            throw new ISRegistryLookup.NoRegistryAvailableException();
        }
        Set<ISRegistryInstance> availableInstances = ISRegistryInstanceGroup.getInstanceGroup().getRegistryInstancesForTypeAndScope(type, this.scope);
        for (ISRegistryInstance instance : availableInstances) {
            if (!instance.getEndpoint().toString().contains(GHNContext.getContext().getPublishedHostnameAndPort())) continue;
            return true;
        }
        return false;
    }
}

