/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.registrations.resources;

import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstance;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstanceGroup;

public class ISRegistryLookup
extends GCUBEHandler<GCUBEScope> {
    public void run() throws Exception {
        this.logger.trace((Object)"Querying the IS for Registry instances");
        List<GCUBERunningInstance> instances = this.queryForISRegistry();
        this.logger.trace((Object)("Number of instances discovered: " + instances.size()));
        if (instances.size() == 0) {
            throw new NoRegistryAvailableException();
        }
        ISRegistryInstanceGroup availableInstances = ISRegistryInstanceGroup.getInstanceGroup();
        for (GCUBERunningInstance instance : instances) {
            availableInstances.addRegistry(ISRegistryInstance.fromGCUBERunningInstance(instance));
        }
    }

    private List<GCUBERunningInstance> queryForISRegistry() throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERIQuery lookupQuery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
        lookupQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", ISRegistryInstance.ISREGISTRY_NAME)});
        lookupQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceClass", ISRegistryInstance.ISREGISTRY_CLASS)});
        return client.execute((ISQuery)lookupQuery, (GCUBEScope)this.getHandled());
    }

    public static class NoRegistryAvailableException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

