/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.resultset.elements;

import java.util.UUID;

public class WSRSSessionToken {
    private String serviceInstance = null;
    private String token = null;

    public WSRSSessionToken(String serviceInstance, String token) {
        this.serviceInstance = serviceInstance;
        this.token = token;
    }

    public String getServiceInstance() {
        return this.serviceInstance;
    }

    public String getSessionToken() {
        return this.token;
    }

    public static String generateSessionToken() {
        return UUID.randomUUID().toString();
    }

    public static String serialize(WSRSSessionToken session) {
        return session.getServiceInstance() + "?" + session.getSessionToken();
    }

    public static WSRSSessionToken deserialize(String session) throws Exception {
        int index = session.lastIndexOf("?");
        if (index <= 0 || index == session.length() - 1) {
            throw new Exception("invalid serialization " + session);
        }
        return new WSRSSessionToken(session.substring(0, index), session.substring(index + 1, session.length()));
    }
}

