/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.configuration.parameter;

import gr.uoa.di.madgik.commons.configuration.parameter.ICloneable;
import gr.uoa.di.madgik.commons.configuration.parameter.IParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.elements.Constructor;
import gr.uoa.di.madgik.commons.configuration.parameter.elements.Method;
import gr.uoa.di.madgik.commons.utils.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ObjectParameter
implements IParameter {
    private String Name = null;
    private Object Value = null;
    private boolean generated = false;
    private boolean internal = false;
    private String ClassName = null;
    private Constructor Constructor = null;
    private List<Method> Methods = null;
    private boolean checked = false;
    private boolean shared = false;

    @Override
    public Class<?> GetParameterClassType() {
        return this.Value.getClass();
    }

    @Override
    public Boolean IsChecked() {
        return this.checked;
    }

    @Override
    public void Check() {
        this.checked = true;
    }

    public String GetClassName() {
        return this.ClassName;
    }

    public Constructor GetConstructor() {
        return this.Constructor;
    }

    public List<Method> GetMethods() {
        Collections.sort(this.Methods);
        return this.Methods;
    }

    @Override
    public IParameter.ParameterType GetParameterType() {
        return IParameter.ParameterType.Object;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public Boolean IsGenerated() {
        return this.generated;
    }

    @Override
    public Boolean IsInternal() {
        return this.internal;
    }

    public Boolean IsShared() {
        return this.shared;
    }

    @Override
    public Object GetValue() {
        if (!this.IsShared().booleanValue() && this.Value instanceof ICloneable) {
            return ((ICloneable)this.Value).Clone();
        }
        return this.Value;
    }

    @Override
    public void SetValue(Object Value) throws Exception {
        this.Value = Value;
    }

    @Override
    public void FromXML(String xml) throws Exception {
        Document doc = XMLUtils.Deserialize(xml);
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element element) throws Exception {
        if (!XMLUtils.AttributeExists(element, "name").booleanValue()) {
            throw new Exception("Not valid serialization of parameter");
        }
        this.Name = XMLUtils.GetAttribute(element, "name");
        if (!XMLUtils.AttributeExists(element, "type").booleanValue()) {
            throw new Exception("Not valid serialization of parameter");
        }
        if (!IParameter.ParameterType.valueOf(XMLUtils.GetAttribute(element, "type")).equals((Object)IParameter.ParameterType.Object)) {
            throw new Exception("Not valid serialization of parameter");
        }
        if (!XMLUtils.AttributeExists(element, "shared").booleanValue()) {
            throw new Exception("Not valid serialization of parameter");
        }
        this.shared = Boolean.getBoolean(XMLUtils.GetAttribute(element, "shared"));
        if (!XMLUtils.AttributeExists(element, "generated").booleanValue()) {
            throw new Exception("Not valid serialization of parameter");
        }
        this.generated = Boolean.getBoolean(XMLUtils.GetAttribute(element, "generated"));
        if (!XMLUtils.AttributeExists(element, "internal").booleanValue()) {
            throw new Exception("Not valid serialization of parameter");
        }
        this.internal = Boolean.getBoolean(XMLUtils.GetAttribute(element, "internal"));
        if (!this.generated) {
            Element classelem = XMLUtils.GetChildElementWithName(element, "class");
            if (classelem == null) {
                throw new Exception("Not valid serialization of parameter");
            }
            if (!XMLUtils.AttributeExists(classelem, "value").booleanValue()) {
                throw new Exception("Not valid serialization of parameter");
            }
            this.ClassName = XMLUtils.GetAttribute(classelem, "value");
            Element constrelem = XMLUtils.GetChildElementWithName(element, "constructor");
            if (constrelem == null) {
                this.Constructor = null;
            } else {
                this.Constructor = new Constructor();
                this.Constructor.FromXML(constrelem);
            }
            Element callselem = XMLUtils.GetChildElementWithName(element, "calls");
            if (callselem == null) {
                this.Methods = new ArrayList<Method>();
            } else {
                this.Methods = new ArrayList<Method>();
                List<Element> methelems = XMLUtils.GetChildElementsWithName(callselem, "method");
                for (Element meth : methelems) {
                    Method m = new Method();
                    m.FromXML(meth);
                    this.Methods.add(m);
                }
            }
        }
    }
}

