/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.types.DescriptiveProperty;

public abstract class GCUBEPluginContext {
    private Map<String, DescriptiveProperty> properties = new HashMap<String, DescriptiveProperty>();
    private List<TypeMapping> mappings = new ArrayList<TypeMapping>();
    private GCUBEService plugin;

    public void initialise(GCUBEService plugin) {
        this.plugin = plugin;
    }

    public GCUBEService getPlugin() {
        return this.plugin;
    }

    public Map<String, DescriptiveProperty> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    protected void addProperty(DescriptiveProperty ... properties) {
        if (properties != null) {
            for (DescriptiveProperty property : properties) {
                this.properties.put(property.getName(), property);
            }
        }
    }

    public List<TypeMapping> getTypeMappings() {
        return Collections.unmodifiableList(this.mappings);
    }

    protected void addTypeMappings(TypeMapping ... mappings) {
        if (mappings != null) {
            this.mappings.addAll(Arrays.asList(mappings));
        }
    }

    public class TypeMapping {
        public Class<?> clazz;
        public QName qname;
        public SerializerFactory sFactory;
        public DeserializerFactory dfactory;

        public TypeMapping(Class<?> clazz, QName qname, SerializerFactory sfaFactory, DeserializerFactory dfactory) {
            this.clazz = clazz;
            this.dfactory = dfactory;
            this.qname = qname;
            this.sFactory = sfaFactory;
        }

        public TypeMapping(Class<?> clazz, QName qname) {
            this.clazz = clazz;
            this.dfactory = new BeanDeserializerFactory(clazz, qname);
            this.qname = qname;
            this.sFactory = new BeanSerializerFactory(clazz, qname);
        }
    }
}

